/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.core.ui.util.TableUtils;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginRegistry;

public class PluginTable
extends JPanel {
    private static final long serialVersionUID = 6305532687611320179L;
    private JTable table;
    private PluginUpdateTableModel tableModel;
    private PluginRegistry provider;
    private List<ListSelectionListener> pendingListeners = new ArrayList<ListSelectionListener>();
    private ComponentAdapter componentAdapter = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent event) {
            PluginTable.this.removeComponentListener(PluginTable.this.componentAdapter);
            PluginTable.this.handleTableShown();
        }
    };
    private JLabel waitLabel;

    public PluginTable(PluginRegistry provider) {
        this.setOpaque(false);
        this.provider = provider;
        this.addComponentListener(this.componentAdapter);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 200));
        this.waitLabel = new JLabel("Checking for plugins...", Icons.getIcon("busy.gif"), 0);
        this.add((Component)this.waitLabel, "Center");
    }

    private void handleTableShown() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                PluginTable.this.tableModel = new PluginUpdateTableModel(PluginTable.this.provider);
                PluginTable.this.table = new JTable(PluginTable.this.tableModel);
                PluginTable.this.table.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
                PluginTable.this.table.setShowGrid(true);
                PluginTable.this.table.setRowMargin(1);
                PluginTable.this.table.setGridColor(Color.LIGHT_GRAY);
                PluginTable.this.table.setRowHeight(PluginTable.this.table.getRowHeight() + 5);
                PluginTable.this.table.setRowSelectionAllowed(true);
                PluginTable.this.table.setColumnSelectionAllowed(false);
                TableUtils.pack(PluginTable.this.table, true, false, 3);
                final JScrollPane tableSp = new JScrollPane(PluginTable.this.table);
                for (ListSelectionListener l : PluginTable.this.pendingListeners) {
                    PluginTable.this.table.getSelectionModel().addListSelectionListener(l);
                }
                PluginTable.this.pendingListeners.clear();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PluginTable.this.remove(PluginTable.this.waitLabel);
                        PluginTable.this.add((Component)tableSp, "Center");
                        PluginTable.this.validate();
                    }
                });
            }
        }, "Load plugin table contents");
        t.start();
    }

    public List<PluginInfo> getSelectedUpdateInfo() {
        if (this.tableModel != null) {
            return this.tableModel.getSelectedUpdateInfo();
        }
        return Collections.emptyList();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        if (this.table == null) {
            this.pendingListeners.add(l);
        } else {
            this.table.getSelectionModel().addListSelectionListener(l);
        }
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.table.getSelectionModel().removeListSelectionListener(l);
    }

    public PluginInfo getCurrentUpdateInfo() {
        if (this.table != null && this.table.getSelectedRow() >= 0) {
            return this.tableModel.getUpdateInfoAt(this.table.getSelectedRow());
        }
        return null;
    }

    private class PluginUpdateTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 7766791162497899167L;
        private List<Boolean> install;
        private final String[] colNames = new String[]{"Install", "Name", "Current version", "Available version"};
        private PluginRegistry provider;

        public PluginUpdateTableModel(PluginRegistry provider) {
            this.provider = provider;
            this.getInstallList();
        }

        public List<Boolean> getInstallList() {
            if (this.install == null) {
                this.install = new ArrayList<Boolean>(this.getUpdateInfoList().size());
                for (PluginInfo info : this.getUpdateInfoList()) {
                    this.install.add(this.provider.isSelected(info));
                }
            }
            return this.install;
        }

        public List<PluginInfo> getUpdateInfoList() {
            return this.provider.getAvailableDownloads();
        }

        public PluginInfo getUpdateInfoAt(int index) {
            return this.getUpdateInfoList().get(index);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        public List<PluginInfo> getSelectedUpdateInfo() {
            ArrayList<PluginInfo> sel = new ArrayList<PluginInfo>();
            int counter = 0;
            for (Boolean b : this.getInstallList()) {
                if (b.booleanValue()) {
                    sel.add(this.getUpdateInfoList().get(counter));
                }
                ++counter;
            }
            return sel;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return this.getUpdateInfoList().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.getInstallList().get(rowIndex);
            }
            PluginInfo info = this.getUpdateInfoList().get(rowIndex);
            if (columnIndex == 1) {
                if (info.getPluginDescriptor() != null) {
                    return info.getPluginDescriptor().getHeaders().get("Bundle-Name");
                }
                return info.getLabel();
            }
            if (columnIndex == 2) {
                Bundle bundle = info.getPluginDescriptor();
                StringBuilder versionString = new StringBuilder();
                if (bundle != null) {
                    Version version = PluginUtilities.getBundleVersion(bundle);
                    versionString.append(version.getMajor());
                    versionString.append(".");
                    versionString.append(version.getMinor());
                    versionString.append(".");
                    versionString.append(version.getMicro());
                    if (version.getQualifier() != null) {
                        versionString.append(".");
                        versionString.append(version.getQualifier());
                    }
                }
                return versionString;
            }
            return info.getAvailableVersion();
        }

        @Override
        public String getColumnName(int column) {
            return this.colNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0 && aValue instanceof Boolean) {
                this.getInstallList().set(rowIndex, (Boolean)aValue);
            }
        }
    }
}

