/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginRegistry;
import org.protege.editor.core.update.UpdateChecker;
import org.protege.editor.core.update.UpdateException;

public class PluginRegistryImpl
implements PluginRegistry {
    private static final Logger logger = Logger.getLogger(PluginRegistryImpl.class);
    public static final String UPDATE_URL = "Update-Url";
    private URL root;
    private PluginRegistryType pluginType;
    private List<PluginInfo> plugins = null;

    public PluginRegistryImpl(URL root, PluginRegistryType pluginType) {
        this.root = root;
        this.pluginType = pluginType;
    }

    public void reload() {
        this.plugins = new ArrayList<PluginInfo>();
        new Calculator().run();
    }

    @Override
    public List<PluginInfo> getAvailableDownloads() {
        if (this.plugins == null) {
            this.reload();
        }
        return this.plugins;
    }

    @Override
    public boolean isSelected(PluginInfo download) {
        return this.pluginType == PluginRegistryType.PLUGIN_UPDATE_REGISTRY;
    }

    private class Calculator
    implements Runnable {
        private BundleContext context = PluginUtilities.getInstance().getApplicationContext();
        private Map<String, Bundle> bundleByIds = new HashMap<String, Bundle>();
        private Set<String> selfUpdatingBundleIds = new HashSet<String>();
        private Set<URL> visitedURLs = new HashSet<URL>();

        private Calculator() {
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting calculation of " + (Object)((Object)PluginRegistryImpl.this.pluginType)));
            }
            this.checkBundles();
            this.visit(PluginRegistryImpl.this.root);
        }

        private void checkBundles() {
            if (this.context != null) {
                for (Bundle bundle : this.context.getBundles()) {
                    this.bundleByIds.put(bundle.getSymbolicName(), bundle);
                }
            }
            if (PluginRegistryImpl.this.pluginType == PluginRegistryType.PLUGIN_UPDATE_REGISTRY) {
                for (Bundle bundle : this.context.getBundles()) {
                    try {
                        URL url;
                        UpdateChecker checker;
                        PluginInfo info;
                        String updateLocation = (String)bundle.getHeaders().get(PluginRegistryImpl.UPDATE_URL);
                        if (updateLocation == null || (info = (checker = new UpdateChecker(url = new URL(updateLocation), bundle)).run()) == null || info.getAvailableVersion().compareTo(bundle.getVersion()) <= 0) continue;
                        info.setPluginDescriptor(bundle);
                        PluginRegistryImpl.this.plugins.add(info);
                        this.selfUpdatingBundleIds.add(info.getId());
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Found self updating bundle " + info.getId()));
                    }
                    catch (Throwable e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)((String)bundle.getHeaders().get("Bundle-Name") + " self update failed: " + e.getMessage()));
                    }
                }
            }
        }

        private void visit(URL node) {
            if (!this.visitedURLs.contains(node)) {
                this.visitedURLs.add(node);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Examining node " + node));
                }
                try {
                    UpdateChecker checker = new UpdateChecker(node, null);
                    PluginInfo info = checker.run();
                    if (info != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Node " + node + "has valid Plugin Info: " + info.getId()));
                        }
                        if (PluginRegistryImpl.this.pluginType == PluginRegistryType.PLUGIN_DOWNLOAD_REGISTRY && !this.bundleByIds.containsKey(info.getId())) {
                            PluginRegistryImpl.this.plugins.add(info);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Node " + node + " is a download"));
                            }
                        }
                        Bundle bundle = this.bundleByIds.get(info.getId());
                        if (PluginRegistryImpl.this.pluginType == PluginRegistryType.PLUGIN_UPDATE_REGISTRY && bundle != null && bundle.getVersion().compareTo(info.getAvailableVersion()) < 0 && !this.selfUpdatingBundleIds.contains(info.getId())) {
                            info.setPluginDescriptor(bundle);
                            PluginRegistryImpl.this.plugins.add(info);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Node " + node + " is a update"));
                            }
                        }
                    }
                }
                catch (MalformedURLException e) {
                    this.readRegistry(node);
                }
                catch (UpdateException e) {
                    this.readRegistry(node);
                }
                catch (IOException e) {
                    logger.debug((Object)"Cannot open remote plugin file/registry", (Throwable)e);
                }
            }
        }

        private void readRegistry(URL node) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying node " + node + " as a registry"));
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(node.openStream())));
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\treading line from node " + node + ":" + line));
                    }
                    if (line.length() <= 0 || line.startsWith("//")) continue;
                    try {
                        URL url = new URL(line);
                        this.visit(url);
                    }
                    catch (MalformedURLException urlException) {
                        logger.debug((Object)("Invalid URL in plugin registry: " + line));
                    }
                }
                reader.close();
            }
            catch (IOException ex) {
                logger.debug((Object)"Cannot open remote plugin registry", (Throwable)ex);
            }
        }
    }

    public static enum PluginRegistryType {
        PLUGIN_UPDATE_REGISTRY("Updates"),
        PLUGIN_DOWNLOAD_REGISTRY("Downloads");

        private String label;

        private PluginRegistryType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

