/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.progress.BackgroundTask;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginInstaller;
import org.protege.editor.core.update.PluginPanel;
import org.protege.editor.core.update.PluginRegistry;
import org.protege.editor.core.update.PluginRegistryImpl;

public class PluginManager {
    private static PluginManager instance;
    public static final String AUTO_UPDATE_KEY = "CheckForUpdates";
    public static final String PLUGIN_REGISTRY_KEY = "plugin.registry-4.1-release.url";
    public static final String DEFAULT_REGISTRY = "http://protege.googlecode.com/svn/trunk/autoupdate/4_2/4.2-plugins-2012-03-19.repository";
    private PluginRegistry pluginRegistry;

    private PluginManager() {
    }

    public static synchronized PluginManager getInstance() {
        if (instance == null) {
            instance = new PluginManager();
        }
        return instance;
    }

    private Preferences getPrefs() {
        PreferencesManager man = PreferencesManager.getInstance();
        return man.getApplicationPreferences(PluginManager.class);
    }

    public void setAutoUpdateEnabled(boolean b) {
        this.getPrefs().putBoolean(AUTO_UPDATE_KEY, b);
    }

    public boolean isAutoUpdateEnabled() {
        return this.getPrefs().getBoolean(AUTO_UPDATE_KEY, true);
    }

    public URL getPluginRegistryLocation() {
        String pluginRegistryLoc = this.getPrefs().getString(PLUGIN_REGISTRY_KEY, DEFAULT_REGISTRY);
        try {
            return new URL(pluginRegistryLoc);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPluginRegistryLocation(URL url) {
        String oldPluginRegistryLoc = this.getPrefs().getString(PLUGIN_REGISTRY_KEY, DEFAULT_REGISTRY);
        String newPluginRegistryLoc = url.toString();
        if (!newPluginRegistryLoc.equals(oldPluginRegistryLoc)) {
            this.getPrefs().putString(PLUGIN_REGISTRY_KEY, newPluginRegistryLoc);
            this.pluginRegistry = null;
        }
    }

    public PluginRegistry getPluginRegistry() {
        if (this.pluginRegistry == null) {
            this.pluginRegistry = new PluginRegistryImpl(this.getPluginRegistryLocation(), PluginRegistryImpl.PluginRegistryType.PLUGIN_DOWNLOAD_REGISTRY);
        }
        return this.pluginRegistry;
    }

    public void checkForUpdates() {
        final BackgroundTask task = ProtegeApplication.getBackgroundTaskManager().startTask("searching for updates");
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<PluginInfo> updates;
                PluginRegistryImpl updatesProvider;
                try {
                    updatesProvider = new PluginRegistryImpl(PluginManager.this.getPluginRegistryLocation(), PluginRegistryImpl.PluginRegistryType.PLUGIN_UPDATE_REGISTRY);
                    updates = updatesProvider.getAvailableDownloads();
                }
                finally {
                    ProtegeApplication.getBackgroundTaskManager().endTask(task);
                }
                if (!updates.isEmpty()) {
                    LinkedHashMap<String, PluginRegistry> map = new LinkedHashMap<String, PluginRegistry>();
                    map.put("Updates", updatesProvider);
                    PluginManager.this.showUpdatesDialog(map);
                } else {
                    JOptionPane.showMessageDialog(null, "No updates available at this time.");
                }
            }
        };
        Thread t = new Thread(runnable, "Check for updates");
        t.setPriority(1);
        t.start();
    }

    public void checkForDownloads() {
        final BackgroundTask task = ProtegeApplication.getBackgroundTaskManager().startTask("searching for downloads");
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<PluginInfo> downloads;
                try {
                    PluginRegistry registry = PluginManager.this.getPluginRegistry();
                    downloads = registry.getAvailableDownloads();
                }
                finally {
                    ProtegeApplication.getBackgroundTaskManager().endTask(task);
                }
                if (!downloads.isEmpty()) {
                    LinkedHashMap<String, PluginRegistry> map = new LinkedHashMap<String, PluginRegistry>();
                    map.put("Downloads", PluginManager.this.getPluginRegistry());
                    PluginManager.this.showUpdatesDialog(map);
                } else {
                    JOptionPane.showMessageDialog(null, "No downloads available at this time.");
                }
            }
        };
        Thread t = new Thread(runnable, "Check for downloads");
        t.setPriority(1);
        t.start();
    }

    public void performAutoUpdate() {
        final BackgroundTask autoUpdateTask = ProtegeApplication.getBackgroundTaskManager().startTask("autoupdate");
        Runnable runnable = new Runnable(){
            PluginRegistry updatesProvider;
            List<PluginInfo> updates;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.updatesProvider = new PluginRegistryImpl(PluginManager.this.getPluginRegistryLocation(), PluginRegistryImpl.PluginRegistryType.PLUGIN_UPDATE_REGISTRY);
                    this.updates = this.updatesProvider.getAvailableDownloads();
                }
                finally {
                    ProtegeApplication.getBackgroundTaskManager().endTask(autoUpdateTask);
                }
                if (!this.updates.isEmpty()) {
                    LinkedHashMap<String, PluginRegistry> map = new LinkedHashMap<String, PluginRegistry>();
                    map.put(PluginRegistryImpl.PluginRegistryType.PLUGIN_UPDATE_REGISTRY.getLabel(), this.updatesProvider);
                    map.put(PluginRegistryImpl.PluginRegistryType.PLUGIN_DOWNLOAD_REGISTRY.getLabel(), new PluginRegistryImpl(PluginManager.this.getPluginRegistryLocation(), PluginRegistryImpl.PluginRegistryType.PLUGIN_DOWNLOAD_REGISTRY));
                    PluginManager.this.showUpdatesDialog(map);
                }
            }
        };
        Thread t = new Thread(runnable, "Auto-update");
        t.setPriority(1);
        t.start();
    }

    public void performCheckPlugins() {
        final BackgroundTask autoUpdateTask = ProtegeApplication.getBackgroundTaskManager().startTask("searching for plugins");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PluginRegistryImpl updatesProvider = new PluginRegistryImpl(PluginManager.this.getPluginRegistryLocation(), PluginRegistryImpl.PluginRegistryType.PLUGIN_UPDATE_REGISTRY);
                List<PluginInfo> updates = updatesProvider.getAvailableDownloads();
                if (!updates.isEmpty()) {
                    ProtegeApplication.getBackgroundTaskManager().endTask(autoUpdateTask);
                    LinkedHashMap<String, PluginRegistry> map = new LinkedHashMap<String, PluginRegistry>();
                    map.put(PluginRegistryImpl.PluginRegistryType.PLUGIN_UPDATE_REGISTRY.getLabel(), updatesProvider);
                    map.put(PluginRegistryImpl.PluginRegistryType.PLUGIN_DOWNLOAD_REGISTRY.getLabel(), new PluginRegistryImpl(PluginManager.this.getPluginRegistryLocation(), PluginRegistryImpl.PluginRegistryType.PLUGIN_DOWNLOAD_REGISTRY));
                    PluginManager.this.showUpdatesDialog(map);
                } else {
                    PluginRegistry registry = PluginManager.this.getPluginRegistry();
                    List<PluginInfo> downloads = registry.getAvailableDownloads();
                    ProtegeApplication.getBackgroundTaskManager().endTask(autoUpdateTask);
                    if (!downloads.isEmpty()) {
                        LinkedHashMap<String, PluginRegistry> map = new LinkedHashMap<String, PluginRegistry>();
                        map.put("Downloads", registry);
                        map.put("Updates", updatesProvider);
                        PluginManager.this.showUpdatesDialog(map);
                    } else {
                        JOptionPane.showMessageDialog(null, "No additional plugins / updates available at this time.");
                    }
                }
            }
        };
        Thread t = new Thread(runnable, "Check plugins");
        t.setPriority(1);
        t.start();
    }

    public void showUpdatesDialog(Map<String, PluginRegistry> downloadsProviders) {
        List<PluginInfo> selUpdates = PluginPanel.showDialog(downloadsProviders, null);
        if (selUpdates != null) {
            PluginInstaller installer = new PluginInstaller(selUpdates);
            installer.run();
        }
    }

    public void checkForUpdatesUI() {
    }
}

