/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.protege.editor.core.FileUtils;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ui.progress.BackgroundTask;
import org.protege.editor.core.update.PluginInfo;

public class PluginInstaller {
    private static final Logger logger = Logger.getLogger(PluginInstaller.class);
    private List<PluginInfo> updates;

    public PluginInstaller(List<PluginInfo> updates) {
        this.updates = updates;
    }

    public void run() {
        final BackgroundTask installAllTask = ProtegeApplication.getBackgroundTaskManager().startTask("installing plugins");
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean errorsFound = false;
                boolean someInstalled = false;
                try {
                    for (PluginInfo info : PluginInstaller.this.updates) {
                        InstallerResult result = PluginInstaller.this.install(info);
                        switch (result) {
                            case ERROR: {
                                errorsFound = true;
                                break;
                            }
                            case INSTALLED: {
                                someInstalled = true;
                            }
                        }
                    }
                }
                finally {
                    ProtegeApplication.getBackgroundTaskManager().endTask(installAllTask);
                }
                if (errorsFound) {
                    JOptionPane.showMessageDialog(null, "Some errors found downloading plugins - look at the console log");
                } else if (someInstalled) {
                    JOptionPane.showMessageDialog(null, "Updates will take effect when you next start Protege.");
                } else {
                    JOptionPane.showMessageDialog(null, "Updates will take effect when you next start Protege.");
                }
            }
        };
        Thread t = new Thread(r, "Installing plugins thread");
        t.setPriority(1);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallerResult install(PluginInfo info) {
        BackgroundTask downloading = ProtegeApplication.getBackgroundTaskManager().startTask("downloading " + info.getLabel());
        logger.info((Object)("Downloading " + info.getLabel()));
        try {
            File tempPluginFile = this.downloadPlugin(info);
            if (tempPluginFile == null) {
                logger.error((Object)"Could not download plugin");
                InstallerResult installerResult = InstallerResult.ERROR;
                return installerResult;
            }
            File installedPluginFile = PluginInstaller.copyPluginToInstallLocation(tempPluginFile, info);
            if (installedPluginFile == null) {
                logger.error((Object)"Could not install plugin");
                InstallerResult installerResult = InstallerResult.ERROR;
                return installerResult;
            }
            if (this.installPlugin(installedPluginFile, info)) {
                InstallerResult installerResult = InstallerResult.INSTALLED;
                return installerResult;
            }
            InstallerResult installerResult = InstallerResult.DOWNLOADED;
            return installerResult;
        }
        catch (Throwable t) {
            logger.error((Object)"Exception caught installing plugins", t);
            InstallerResult installerResult = InstallerResult.ERROR;
            return installerResult;
        }
        finally {
            ProtegeApplication.getBackgroundTaskManager().endTask(downloading);
        }
    }

    private File downloadPlugin(PluginInfo info) throws IOException {
        byte[] buffer;
        int read;
        URL downloadURL = info.getDownloadURL();
        String[] path = downloadURL.getFile().split("/");
        String downloadFileName = path[path.length - 1];
        String tmpPath = System.getProperty("java.io.tmpdir");
        File tempPluginFile = new File(tmpPath, downloadFileName);
        tempPluginFile.deleteOnExit();
        URLConnection conn = downloadURL.openConnection();
        BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempPluginFile));
        while ((read = bis.read(buffer = new byte[4068])) != -1) {
            bos.write(buffer, 0, read);
        }
        bis.close();
        bos.flush();
        bos.close();
        if (downloadURL.getFile().endsWith(".zip")) {
            tempPluginFile = PluginInstaller.extractPlugin(tempPluginFile, info);
        }
        return tempPluginFile;
    }

    private static File copyPluginToInstallLocation(File pluginFile, PluginInfo info) throws URISyntaxException {
        logger.info((Object)("Copying " + info.getLabel()));
        boolean doCopy = true;
        File pluginsFolder = new File(System.getProperty("org.protege.plugin.dir"));
        File oldPluginFile = null;
        File newPluginFile = null;
        if (info.getPluginDescriptor() != null) {
            String location = info.getPluginDescriptor().getLocation();
            File existingPlugin = new File(location = location.substring(location.indexOf(":") + 1, location.length()));
            if (existingPlugin.exists()) {
                oldPluginFile = new File(existingPlugin.getAbsolutePath() + "-old");
                doCopy = existingPlugin.renameTo(oldPluginFile);
                newPluginFile = existingPlugin;
            }
        }
        if (newPluginFile == null) {
            newPluginFile = new File(pluginsFolder, info.getId() + ".jar");
        }
        if (doCopy) {
            try {
                FileUtils.copyFileToDirectory(pluginFile, newPluginFile);
                if (oldPluginFile != null && oldPluginFile.exists()) {
                    FileUtils.deleteRecursively(oldPluginFile);
                }
                return newPluginFile;
            }
            catch (IOException e) {
                logger.error((Object)("Could not create plugin: " + newPluginFile), (Throwable)e);
            }
        } else {
            logger.error((Object)"Could not safely install new version of the plugin.");
        }
        return null;
    }

    private static File extractPlugin(File pluginArchive, PluginInfo info) throws IOException {
        ZipEntry entry;
        logger.info((Object)("Extracting " + info.getLabel()));
        File tempDir = new File(pluginArchive.getParentFile(), pluginArchive.getName() + "-extracted");
        tempDir.deleteOnExit();
        tempDir.mkdir();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(pluginArchive)));
        byte[] buffer = new byte[4068];
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.getName().indexOf(".DS_Store") != -1 || entry.getName().indexOf("__MACOSX") != -1) continue;
            File curFile = new File(tempDir, entry.getName());
            if (entry.isDirectory()) {
                curFile.mkdirs();
                continue;
            }
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(curFile));
            int count = 0;
            while ((count = zis.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, count);
            }
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        return PluginInstaller.getPluginDir(tempDir);
    }

    private static File getPluginDir(File startDir) {
        if (!startDir.isDirectory()) {
            if (startDir.getName().endsWith(".jar")) {
                return startDir;
            }
            return null;
        }
        for (File f : startDir.listFiles()) {
            File pluginDir = PluginInstaller.getPluginDir(f);
            if (pluginDir == null) continue;
            return pluginDir;
        }
        return null;
    }

    private boolean installPlugin(File pluginLocation, PluginInfo info) throws BundleException {
        if (info.getPluginDescriptor() == null) {
            logger.info((Object)("Loading " + info.getLabel()));
            Bundle b = ProtegeApplication.getContext().installBundle("file:" + pluginLocation.getPath());
            b.start();
            return true;
        }
        logger.info((Object)("Plugin " + info.getLabel() + " will be loaded when Protege is restarted"));
        return false;
    }

    public static enum InstallerResult {
        DOWNLOADED,
        ERROR,
        INSTALLED;

    }
}

