/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.UpdateException;

public class PluginInfoDocument {
    public static final String ID_PROPERTY_NAME = "id";
    private static final String LABEL_PROPERTY_NAME = "name";
    public static final String VERSION_PROPERTY_NAME = "version";
    public static final String DOWNLOAD_PROPERTY_NAME = "download";
    public static final String DOC_PROPERTY_NAME = "readme";
    private static final String LICENSE_PROPERTY_NAME = "license";
    private static final String AUTHOR_PROPERTY_NAME = "author";
    private PluginInfo info;
    private URL updateFileLocation;

    public PluginInfoDocument(URL updateFileLocation) throws IOException {
        this.updateFileLocation = updateFileLocation;
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(updateFileLocation.openStream()));
        String id = properties.getProperty(ID_PROPERTY_NAME);
        String versionString = properties.getProperty(VERSION_PROPERTY_NAME);
        Version version = null;
        if (versionString != null) {
            version = new Version(versionString);
        }
        String downloadURLStr = properties.getProperty(DOWNLOAD_PROPERTY_NAME);
        URL downloadURL = null;
        if (downloadURLStr != null) {
            downloadURL = new URL(downloadURLStr);
        }
        this.info = new PluginInfo(id, version, downloadURL);
        String readmeStr = properties.getProperty(DOC_PROPERTY_NAME);
        if (readmeStr != null) {
            this.info.setReadmeURI(new URL(readmeStr));
        }
        this.info.setLicense(properties.getProperty(LICENSE_PROPERTY_NAME));
        this.info.setAuthor(properties.getProperty(AUTHOR_PROPERTY_NAME));
        this.info.setLabel(properties.getProperty(LABEL_PROPERTY_NAME));
    }

    public boolean isValid(Bundle bundle) throws UpdateException {
        if (this.info.getId() == null) {
            throw new UpdateException(this.info.getId(), this.updateFileLocation, "No plugin ID given");
        }
        if (bundle != null) {
            String pluginID = bundle.getSymbolicName();
            if (!this.info.getId().equals(pluginID)) {
                throw new UpdateException(this.info.getId(), this.updateFileLocation, "ID does not match the plugin (" + pluginID + ")");
            }
        }
        if (this.info.getAvailableVersion() == null) {
            throw new UpdateException(this.info.getId(), this.updateFileLocation, "Cannot find version");
        }
        if (this.info.getDownloadURL() == null) {
            throw new UpdateException(this.info.getId(), this.updateFileLocation, "No download location given");
        }
        return true;
    }

    public PluginInfo getPluginInfo() {
        return this.info;
    }
}

