/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.net.URL;
import javax.swing.Icon;
import org.eclipse.core.runtime.IExtension;
import org.osgi.framework.Bundle;
import org.protege.editor.core.plugin.ExtensionInstantiator;
import org.protege.editor.core.plugin.JPFUtil;
import org.protege.editor.core.plugin.PluginProperties;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.ui.workspace.TabbedWorkspace;
import org.protege.editor.core.ui.workspace.WorkspaceTab;
import org.protege.editor.core.ui.workspace.WorkspaceTabPlugin;

public class WorkspaceTabPluginJPFImpl
implements WorkspaceTabPlugin {
    public static final String ID = "WorkspaceTab";
    private static final String LABEL_PARAM = "label";
    private static final String INDEX_PARAM = "index";
    private static final String DEFAULT_VIEW_CONFIG_FILE_NAME_PARAM = "defaultViewConfigFileName";
    private TabbedWorkspace workspace;
    private IExtension extension;

    public WorkspaceTabPluginJPFImpl(TabbedWorkspace workspace, IExtension extension) {
        this.extension = extension;
        this.workspace = workspace;
    }

    @Override
    public TabbedWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public String getId() {
        return this.extension.getUniqueIdentifier();
    }

    @Override
    public String getLabel() {
        return PluginProperties.getParameterValue(this.extension, LABEL_PARAM, "<Error! No label defined>");
    }

    @Override
    public String getIndex() {
        return PluginProperties.getParameterValue(this.extension, INDEX_PARAM, "Z");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDocumentation() {
        return JPFUtil.getDocumentation(this.extension);
    }

    @Override
    public WorkspaceTab newInstance() throws InstantiationException, ClassNotFoundException, IllegalAccessException {
        ExtensionInstantiator instantiator = new ExtensionInstantiator(this.extension);
        WorkspaceTab tab = (WorkspaceTab)instantiator.instantiate();
        tab.setup(this);
        return tab;
    }

    @Override
    public URL getDefaultViewConfigFile() {
        PluginUtilities util = PluginUtilities.getInstance();
        Bundle contributor = util.getBundle(this.extension);
        String resource = PluginProperties.getParameterValue(this.extension, DEFAULT_VIEW_CONFIG_FILE_NAME_PARAM, null);
        if (resource != null) {
            return contributor.getResource(resource);
        }
        return null;
    }
}

