/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalTheme;
import org.apache.log4j.Logger;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.about.AboutPanel;
import org.protege.editor.core.ui.preferences.PreferencesDialogPanel;
import org.protege.editor.core.ui.split.ViewSplitPane;
import org.protege.editor.core.ui.util.ProtegePlasticTheme;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginLoader;
import org.protege.editor.core.ui.view.ViewHolder;
import org.protege.editor.core.ui.workspace.WorkspaceViewManager;

public abstract class Workspace
extends JComponent
implements Disposable {
    private static final long serialVersionUID = 1737700990946291204L;
    public static final int BOTTOM_RESULTS_VIEW = 0;
    public static final int LEFT_RESULTS_VIEW = 1;
    public static final Logger LOGGER = Logger.getLogger(Workspace.class);
    public static final String FILE_MENU_NAME = "File";
    public static final String WINDOW_MENU_NAME = "Window";
    private static final String HELP_MENU_NAME = "Help";
    public static final String RESULT_PANE_ID = "org.protege.editor.core.resultspane";
    private EditorKit editorKit;
    private WorkspaceViewManager viewManager;
    private ViewSplitPane bottomResultsSplitPane;
    private ViewSplitPane leftResultsSplitPane;
    private ViewHolder bottomResultsViewHolder;
    private ViewHolder leftResultsViewHolder;
    private int fontSize = 12;

    public void setup(EditorKit editorKit) {
        this.editorKit = editorKit;
        this.viewManager = new WorkspaceViewManager();
        this.setLayout(new BorderLayout());
        this.leftResultsSplitPane = new ViewSplitPane(1);
        this.leftResultsSplitPane.setResizeWeight(0.2);
        this.add(this.leftResultsSplitPane);
        this.bottomResultsSplitPane = new ViewSplitPane(0);
        this.bottomResultsSplitPane.setResizeWeight(0.65);
        this.leftResultsSplitPane.add((Component)this.bottomResultsSplitPane, "right");
        this.bottomResultsViewHolder = new ViewHolder("Results", "bottom", this.bottomResultsSplitPane);
        Workspace.adjustBorder(this.bottomResultsViewHolder);
        this.leftResultsViewHolder = new ViewHolder("R", "left", this.leftResultsSplitPane);
        Workspace.adjustBorder(this.leftResultsViewHolder);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void changeFontSize(int delta) {
        this.fontSize += delta;
        if (this.fontSize < 1) {
            this.fontSize = 1;
        }
    }

    private static void adjustBorder(ViewHolder holder) {
        Border currentBorder = holder.getBorder();
        holder.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), currentBorder));
    }

    protected void initialiseExtraMenuItems(JMenuBar menuBar) {
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (menu.getText().equals(WINDOW_MENU_NAME)) {
                this.installLookAndFeelMenu(menu);
                continue;
            }
            if (menu.getText().equals(FILE_MENU_NAME)) {
                if (OSUtils.isOSX()) continue;
                JMenuItem menuItem = new JMenuItem(new AbstractAction("Preferences..."){
                    private static final long serialVersionUID = -4897769796985728041L;

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        PreferencesDialogPanel.showPreferencesDialog(null, Workspace.this.getEditorKit());
                    }
                });
                KeyStroke ks = KeyStroke.getKeyStroke(",");
                menuItem.setAccelerator(ks);
                menu.addSeparator();
                menu.add(menuItem);
                menu.addSeparator();
                menu.add(new AbstractAction("Exit"){
                    private static final long serialVersionUID = -3497054762240815779L;

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ProtegeApplication.handleQuit();
                    }
                });
                continue;
            }
            if (!menu.getText().equals(HELP_MENU_NAME) || OSUtils.isOSX()) continue;
            menu.addSeparator();
            menu.add(new AbstractAction("About"){
                private static final long serialVersionUID = 3773470646910947172L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    AboutPanel.showDialog();
                }
            });
        }
    }

    private void installLookAndFeelMenu(JMenu windowMenu) {
        windowMenu.addSeparator();
        JMenu menu = new JMenu("Look & Feel");
        ButtonGroup lafMenuItemGroup = new ButtonGroup();
        windowMenu.add(menu);
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences("LOOK_AND_FEEL_KEY");
        String lafName = p.getString("LOOK_AND_FEEL_CLASS_NAME", "");
        JRadioButtonMenuItem protegeDefaultMenuItem = new JRadioButtonMenuItem(new AbstractAction("Protege Default"){
            private static final long serialVersionUID = -1460075802676626382L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Workspace.this.setProtegeDefaultLookAndFeel("com.jgoodies.looks.plastic.PlasticLookAndFeel");
            }
        });
        lafMenuItemGroup.add(protegeDefaultMenuItem);
        protegeDefaultMenuItem.setSelected(lafName.equals("com.jgoodies.looks.plastic.PlasticLookAndFeel"));
        menu.add(protegeDefaultMenuItem);
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            final String className = info.getClassName();
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(new AbstractAction(info.getName()){
                private static final long serialVersionUID = 2912631603213508312L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Workspace.this.setLookAndFeel(className);
                }
            });
            lafMenuItemGroup.add(menuItem);
            menuItem.setSelected(lafName.equals(className));
            menu.add(menuItem);
        }
        JRadioButtonMenuItem plastic3DmenuItem = new JRadioButtonMenuItem(new AbstractAction("Plastic 3D"){
            private static final long serialVersionUID = 6933202663872017353L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Workspace.this.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            }
        });
        lafMenuItemGroup.add(plastic3DmenuItem);
        plastic3DmenuItem.setSelected(lafName.equals("com.jgoodies.looks.plastic.Plastic3DLookAndFeel"));
        menu.add(plastic3DmenuItem);
    }

    private void setProtegeDefaultLookAndFeel(String lafName) {
        try {
            LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(lafName).newInstance();
            PopupFactory.setSharedInstance(new PopupFactory());
            PlasticLookAndFeel.setCurrentTheme((MetalTheme)((Object)new ProtegePlasticTheme()));
            PlasticLookAndFeel.setTabStyle((String)"metal");
            FontSet fontSet = FontSets.createDefaultFontSet((Font)ProtegePlasticTheme.DEFAULT_FONT);
            FontPolicy fixedPolicy = FontPolicies.createFixedPolicy((FontSet)fontSet);
            PlasticLookAndFeel.setFontPolicy((FontPolicy)fixedPolicy);
            UIManager.put("ClassLoader", lookAndFeel.getClass().getClassLoader());
            UIManager.setLookAndFeel(lookAndFeel);
            SwingUtilities.updateComponentTreeUI(this);
            Preferences p = PreferencesManager.getInstance().getApplicationPreferences("LOOK_AND_FEEL_KEY");
            p.putString("LOOK_AND_FEEL_CLASS_NAME", lafName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn((Object)("Look and feel not found: " + lafName));
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.toString());
        }
    }

    private void setLookAndFeel(String clsName) {
        try {
            UIManager.setLookAndFeel(clsName);
            SwingUtilities.updateComponentTreeUI(this);
            Preferences p = PreferencesManager.getInstance().getApplicationPreferences("LOOK_AND_FEEL_KEY");
            p.putString("LOOK_AND_FEEL_CLASS_NAME", clsName);
        }
        catch (Exception e1) {
            LOGGER.error((Object)"Exception caught setting look and feel ", (Throwable)e1);
        }
    }

    protected void setContent(JComponent component) {
        this.bottomResultsSplitPane.setTopComponent(component);
    }

    public EditorKit getEditorKit() {
        return this.editorKit;
    }

    public WorkspaceViewManager getViewManager() {
        return this.viewManager;
    }

    public abstract JComponent getStatusArea();

    public void showResultsView(String id, String headerLabel, Color headerColor, ViewComponent viewComponent, boolean replace, int location) {
        ResultsViewComponentPlugin plugin = new ResultsViewComponentPlugin(id, headerLabel, headerColor, viewComponent);
        this.showResultsView(plugin, replace, location);
    }

    public View showResultsView(String id, boolean replace, int location) {
        ViewComponentPluginLoader pluginLoader = new ViewComponentPluginLoader(this);
        for (ViewComponentPlugin plugin : pluginLoader.getPlugins()) {
            if (!id.equals(plugin.getId())) continue;
            return this.showResultsView(plugin, replace, location);
        }
        return null;
    }

    public View showResultsView(ViewComponentPlugin plugin, boolean replace, int location) {
        try {
            View v;
            ViewHolder viewHolder = location == 0 ? this.bottomResultsViewHolder : this.leftResultsViewHolder;
            if (replace && (v = viewHolder.getView(plugin.getId())) != null) {
                v.closeView();
            }
            View view = new View(plugin, this);
            ViewComponent viewComponent = (ViewComponent)plugin.newInstance();
            viewComponent.setup(plugin);
            viewHolder.addView(view);
            return view;
        }
        catch (ClassNotFoundException e) {
            ProtegeApplication.getErrorLog().logError(e);
        }
        catch (IllegalAccessException e) {
            ProtegeApplication.getErrorLog().logError(e);
        }
        catch (InstantiationException e) {
            ProtegeApplication.getErrorLog().logError(e);
        }
        return null;
    }

    public void save() throws Exception {
    }

    @Override
    public void dispose() {
        this.leftResultsViewHolder.dispose();
        this.bottomResultsViewHolder.dispose();
    }

    protected String getTitle() {
        return "";
    }

    private class ResultsViewComponentPlugin
    implements ViewComponentPlugin {
        private String id;
        private ViewComponent viewComponent;
        private String headerLabel;
        private Color headerColor;

        protected ResultsViewComponentPlugin(String id, String headerLabel, Color headerColor, ViewComponent viewComponent) {
            this.id = id;
            this.headerColor = headerColor;
            this.headerLabel = headerLabel;
            this.viewComponent = viewComponent;
        }

        @Override
        public Color getBackgroundColor() {
            return this.headerColor;
        }

        @Override
        public String getLabel() {
            return this.headerLabel;
        }

        @Override
        public Workspace getWorkspace() {
            return Workspace.this;
        }

        @Override
        public boolean isUserCreatable() {
            return false;
        }

        @Override
        public String getDocumentation() {
            return null;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            return this.viewComponent;
        }

        @Override
        public Set<String> getCategorisations() {
            return Collections.singleton("Results");
        }

        @Override
        public Set<String> getNavigates() {
            return Collections.EMPTY_SET;
        }
    }
}

