/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ui.split.ViewSplitPane;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.core.ui.view.View;

public class ViewContainer
extends JComponent
implements Disposable {
    public static Logger LOGGER = Logger.getLogger(ViewContainer.class);
    private static final long serialVersionUID = -1833840751733500882L;

    public ViewContainer(View view) {
        this.setLayout(new BorderLayout());
        this.add(view);
        if (LOGGER.isDebugEnabled()) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createMatteBorder(1, 1, 1, 1, Color.RED)));
        }
    }

    public ViewContainer(ViewContainer left, ViewContainer right, int orientation) {
        this.setLayout(new BorderLayout());
        ViewSplitPane sp = this.createSplitPane(orientation);
        this.add(sp);
        sp.setLeftComponent(left);
        sp.setRightComponent(right);
    }

    public void splitHorizontally(View rightView) {
        rightView.setSyncronizing(false);
        ViewSplitPane sp = this.createSplitPane(0);
        View view = (View)this.getComponent(0);
        this.remove(view);
        this.add(sp);
        this.validate();
        sp.setTopComponent(new ViewContainer(view));
        sp.setBottomComponent(new ViewContainer(rightView));
        sp.setDividerLocation(sp.getHeight() / 2);
    }

    public void splitVertically(View bottomView) {
        bottomView.setSyncronizing(false);
        ViewSplitPane sp = this.createSplitPane(1);
        View view = (View)this.getComponent(0);
        this.remove(view);
        this.add(sp);
        this.validate();
        sp.setLeftComponent(new ViewContainer(view));
        sp.setRightComponent(new ViewContainer(bottomView));
        sp.setDividerLocation(sp.getWidth() / 2);
    }

    private ViewSplitPane createSplitPane(int orientation) {
        TabViewContainerSplitPane sp = new TabViewContainerSplitPane(orientation);
        sp.setResizeWeight(0.5);
        return sp;
    }

    public void closeView(View view) {
        this.remove(view);
        Container parent = this.getParent();
        parent.remove(this);
        if (parent instanceof TabViewContainerSplitPane) {
            this.collapseSplitPane((TabViewContainerSplitPane)parent);
        } else {
            parent.validate();
        }
    }

    public void collapseSplitPane(TabViewContainerSplitPane sp) {
        Component remainingComp = sp.getLeftComponent();
        if (remainingComp == null) {
            remainingComp = sp.getRightComponent();
        }
        sp.remove(remainingComp);
        Container parent = sp.getParent();
        parent.remove(sp);
        parent.add(remainingComp);
        if (remainingComp instanceof ViewContainer) {
            this.collapseTabViewContainer((ViewContainer)remainingComp);
        } else {
            parent.validate();
        }
    }

    public void collapseTabViewContainer(ViewContainer viewContainer) {
        Container parent = viewContainer.getParent();
        if (parent instanceof ViewContainer) {
            parent.remove(viewContainer);
            parent.add(viewContainer.getComponent(0));
            parent.validate();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    @Override
    public void dispose() {
        for (View view : UIUtil.getComponentsExtending(this, View.class)) {
            view.dispose();
        }
    }

    private static class TabViewContainerSplitPane
    extends ViewSplitPane {
        private static final long serialVersionUID = 2614735582419262419L;

        public TabViewContainerSplitPane(int orientation) {
            super(orientation);
        }
    }
}

