/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.coode.mdock.NodePanel;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewHolder;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;

public class CaptureScreenshotAction
extends ProtegeAction {
    public static final String PERMANENT_FOCUS_OWNER_PROPERTY_NAME = "permanentFocusOwner";
    private Component currentView;
    private final PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CaptureScreenshotAction.this.handleFocusManagerPropertyChange(evt);
        }
    };
    public static final CaptureTypePanel captureTypePanel = new CaptureTypePanel();

    @Override
    public void actionPerformed(ActionEvent e) {
        this.takeScreenCaptureOfCurrentView();
    }

    private void takeScreenCaptureOfCurrentView() {
        if (this.currentView == null) {
            return;
        }
        Component currentFocusOwner = this.currentView;
        WorkspaceFrame frame = ProtegeManager.getInstance().getFrame(this.getWorkspace());
        int ret = JOptionPane.showConfirmDialog(frame, captureTypePanel, "Capture type", 2, -1);
        if (ret != 0) {
            return;
        }
        CaptureType captureType = captureTypePanel.getSelectedCaptureType();
        Component component = captureType.getComponentToCapture(currentFocusOwner);
        Dimension size = component.getSize();
        final BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 2);
        Graphics g = bufferedImage.getGraphics();
        component.paintAll(g);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.equals(DataFlavor.imageFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return bufferedImage;
            }
        }, null);
    }

    private void handleFocusManagerPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(PERMANENT_FOCUS_OWNER_PROPERTY_NAME)) {
            this.handlePermanentFocusOwnerChange();
        }
    }

    private void handlePermanentFocusOwnerChange() {
        this.updateState();
    }

    private void updateState() {
        FocusManager fm = FocusManager.getCurrentManager();
        Component permanentFocusOwner = fm.getPermanentFocusOwner();
        this.updateStateForPermanentFocusOwner(permanentFocusOwner);
    }

    private void updateStateForPermanentFocusOwner(Component component) {
        this.currentView = component;
        this.setEnabled(this.currentView != null);
    }

    @Override
    public void initialise() throws Exception {
        FocusManager fm = FocusManager.getCurrentManager();
        fm.addPropertyChangeListener(this.listener);
        this.updateState();
    }

    @Override
    public void dispose() throws Exception {
        FocusManager fm = FocusManager.getCurrentManager();
        fm.removePropertyChangeListener(this.listener);
    }

    private static class CaptureTypePanel
    extends JPanel {
        private static CaptureType lastCaptureType = CaptureType.VIEW_HOLDER;
        private List<JRadioButton> captureTypeButtons = new ArrayList<JRadioButton>();

        private CaptureTypePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("Capture type:"), CaptureTypePanel.getGBG(0, 0, 0.0, 768, 0));
            ButtonGroup bg = new ButtonGroup();
            int currentRow = 0;
            int buttonX = 1;
            for (CaptureType type : CaptureType.values()) {
                JRadioButton typeButton = new JRadioButton(type.name);
                this.captureTypeButtons.add(typeButton);
                if (type.equals((Object)lastCaptureType)) {
                    typeButton.setSelected(true);
                }
                bg.add(typeButton);
                this.add((Component)typeButton, CaptureTypePanel.getGBG(buttonX, currentRow, 0.0, 512, 0));
                ++currentRow;
            }
        }

        public CaptureType getSelectedCaptureType() {
            int index = 0;
            for (JRadioButton radioButton : this.captureTypeButtons) {
                if (radioButton.isSelected()) {
                    lastCaptureType = CaptureType.values()[index];
                    return lastCaptureType;
                }
                ++index;
            }
            return null;
        }

        private static GridBagConstraints getGBG(int x, int y, double wX, int anchor, int fill) {
            return new GridBagConstraints(x, y, 1, 1, wX, 0.0, anchor, fill, new Insets(0, 0, 2, 2), 0, 0);
        }
    }

    public static enum CaptureType {
        VIEW_HOLDER("View and outer component"),
        VIEW("View"),
        VIEW_VIEWPORT("View visible content"),
        VIEW_CONTENT("View complete content");

        private String name;

        private CaptureType(String name) {
            this.name = name;
        }

        public Component getComponentToCapture(Component component) {
            switch (this) {
                case VIEW_HOLDER: {
                    Container parent;
                    Component viewHolder = null;
                    viewHolder = component instanceof View ? component : SwingUtilities.getAncestorOfClass(View.class, component);
                    if (viewHolder == null) {
                        return null;
                    }
                    while (!((parent = viewHolder.getParent()) instanceof NodePanel)) {
                        viewHolder = parent;
                    }
                    return viewHolder;
                }
                case VIEW: {
                    Component view = null;
                    view = component instanceof View ? component : SwingUtilities.getAncestorOfClass(View.class, component);
                    if (view == null) {
                        return null;
                    }
                    return view.getParent();
                }
                case VIEW_VIEWPORT: {
                    if (component instanceof JViewport) {
                        return component;
                    }
                    return SwingUtilities.getAncestorOfClass(JViewport.class, component);
                }
                case VIEW_CONTENT: {
                    Container parent;
                    Component contentParent = component;
                    while (!((parent = contentParent.getParent()) instanceof JViewport) && !(parent instanceof ViewHolder) && parent != null) {
                        contentParent = parent;
                    }
                    return contentParent;
                }
            }
            return component;
        }
    }
}

