/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.core.ui.util.VerifyingOptionPane;

public class JOptionPaneEx {
    private static Logger logger = Logger.getLogger(JOptionPaneEx.class);

    public static int showConfirmDialog(Component parent, String title, JComponent content, int messageType, int optionType, JComponent defaultFocusedComponent) {
        JOptionPane optionPane = new JOptionPane(content, messageType, optionType);
        JDialog dlg = JOptionPaneEx.createDialog(parent, title, optionPane, defaultFocusedComponent);
        dlg.setVisible(true);
        return JOptionPaneEx.getReturnValue(optionPane);
    }

    public static int showConfirmDialog(Component parent, String title, JComponent content, int messageType, int optionType, JComponent defaultFocusedComponent, Object[] options, Object defaultOption) {
        JOptionPane optionPane = new JOptionPane(content, messageType, optionType, null, options, defaultOption);
        JDialog dlg = JOptionPaneEx.createDialog(parent, title, optionPane, defaultFocusedComponent);
        dlg.setVisible(true);
        return JOptionPaneEx.getReturnValue(optionPane);
    }

    public static int showValidatingConfirmDialog(Component parent, String title, JComponent component, int messageType, int optionType, JComponent defaultFocusedComponent) {
        if (component instanceof VerifiedInputEditor) {
            final VerifyingOptionPane optionPane = new VerifyingOptionPane(component, messageType, optionType){
                private static final long serialVersionUID = 7128847118051849761L;

                @Override
                public void selectInitialValue() {
                }
            };
            InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                @Override
                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            ((VerifiedInputEditor)((Object)component)).addStatusChangedListener(verificationListener);
            JDialog dlg = JOptionPaneEx.createDialog(parent, title, optionPane, defaultFocusedComponent);
            dlg.setModal(true);
            dlg.setVisible(true);
            return JOptionPaneEx.getReturnValue(optionPane);
        }
        logger.warn((Object)"Component should implement VerifiedInputEditor for validating dialog to work. Using normal dialog with no validating");
        return JOptionPaneEx.showConfirmDialog(parent, title, component, messageType, optionType, null);
    }

    private static JDialog createDialog(Component parent, String title, JOptionPane optionPane, final JComponent defaultFocusedComponent) {
        JDialog dlg = optionPane.createDialog(parent, title);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (defaultFocusedComponent != null) {
                    defaultFocusedComponent.requestFocusInWindow();
                }
            }
        });
        dlg.setLocationRelativeTo(parent);
        dlg.setResizable(true);
        dlg.pack();
        return dlg;
    }

    private static int getReturnValue(JOptionPane optionPane) {
        Object value = optionPane.getValue();
        if (value != null && optionPane.getOptions() != null) {
            value = Arrays.binarySearch(optionPane.getOptions(), value);
        }
        return value != null ? (Integer)value : -1;
    }
}

