/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.progress;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.protege.editor.core.ui.progress.BackgroundTask;
import org.protege.editor.core.ui.progress.BackgroundTaskListPanel;
import org.protege.editor.core.ui.progress.BackgroundTaskListener;
import org.protege.editor.core.ui.progress.BackgroundTaskManager;
import org.protege.editor.core.ui.util.Icons;

public class BackgroundTaskLabel
extends JLabel
implements BackgroundTaskListener {
    private static final long serialVersionUID = -5229610259844307503L;
    private BackgroundTaskManager mngr;
    private static final int DELAY_MILLIS = 1000;
    private ActionListener timeout = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            BackgroundTaskLabel.this.setVisible(true);
        }
    };
    private Timer t;

    public BackgroundTaskLabel(BackgroundTaskManager mngr) {
        super(Icons.getIcon("busy.gif"));
        this.setOpaque(false);
        this.setVisible(false);
        this.mngr = mngr;
        this.t = new Timer(1000, this.timeout);
        this.t.setRepeats(false);
        mngr.addBusyListener(this);
        this.setupMouseHandler();
    }

    @Override
    public void startTask(BackgroundTask task) {
        if (!this.isVisible() && !this.t.isRunning()) {
            this.t.start();
        }
    }

    @Override
    public void endTask(BackgroundTask task) {
        this.t.stop();
        this.runInSwingThread(new Runnable(){

            @Override
            public void run() {
                BackgroundTaskLabel.this.setVisible(BackgroundTaskLabel.this.mngr.isBusy());
            }
        });
    }

    @Override
    public String getToolTipText() {
        List<BackgroundTask> tasks = this.mngr.getRunningTasks();
        String tt = tasks.get(tasks.size() - 1).toString();
        System.out.println(tt);
        return tt;
    }

    private void setupMouseHandler() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BackgroundTaskLabel.this.showTasks();
            }
        });
    }

    private void showTasks() {
        BackgroundTaskListPanel.showTaskDialog(this.mngr);
    }

    private void runInSwingThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }
}

