/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.preferences.PreferencesPanel;
import org.protege.editor.core.ui.preferences.PreferencesPanelPlugin;
import org.protege.editor.core.ui.preferences.PreferencesPanelPluginLoader;

public class PreferencesDialogPanel
extends JPanel
implements Disposable {
    private static final long serialVersionUID = 6338996558666619642L;
    public static final String RESET_PREFERENCES_CONFIRMATION_DIALOG_TITLE = "Reset preferences?";
    public static final String RESET_PREFERENCES_CONFIRMATION_DIALOG_MESSAGE = "Are you sure you want to reset all preferences to their default settings";
    private Map<String, PreferencesPanel> map = new HashMap<String, PreferencesPanel>();
    private Map<String, JComponent> scrollerMap = new HashMap<String, JComponent>();
    private JTabbedPane tabbedPane;
    private static final String PREFS_HISTORY_PANEL_KEY = "prefs.history.panel";
    private boolean wasReset = false;

    public PreferencesDialogPanel(EditorKit editorKit) {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        PreferencesPanelPluginLoader loader = new PreferencesPanelPluginLoader(editorKit);
        TreeSet<PreferencesPanelPlugin> plugins = new TreeSet<PreferencesPanelPlugin>(new Comparator<PreferencesPanelPlugin>(){

            @Override
            public int compare(PreferencesPanelPlugin o1, PreferencesPanelPlugin o2) {
                String s1 = o1.getLabel();
                String s2 = o2.getLabel();
                return s1.compareTo(s2);
            }
        });
        plugins.addAll(loader.getPlugins());
        for (PreferencesPanelPlugin plugin : plugins) {
            try {
                PreferencesPanel panel = (PreferencesPanel)plugin.newInstance();
                panel.initialise();
                String label = plugin.getLabel();
                JScrollPane scroller = new JScrollPane(panel);
                scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.map.put(label, panel);
                this.scrollerMap.put(label, scroller);
                this.tabbedPane.addTab(label, scroller);
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
        this.add(this.tabbedPane);
    }

    @Override
    public void dispose() {
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.map.values())) {
            try {
                panel.dispose();
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
        this.map.clear();
    }

    public void applyPreferences() {
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.map.values())) {
            try {
                panel.applyChanges();
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
    }

    protected String getSelectedPanel() {
        Component c = this.tabbedPane.getSelectedComponent();
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getView();
        }
        for (String tabName : this.map.keySet()) {
            if (!c.equals(this.map.get(tabName))) continue;
            return tabName;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(850, 725);
    }

    public static void showPreferencesDialog(String selectedPanel, EditorKit editorKit) {
        Component c;
        final PreferencesDialogPanel preferencesPanel = new PreferencesDialogPanel(editorKit);
        JPanel holder = new JPanel(new BorderLayout(4, 4));
        holder.add(preferencesPanel);
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences(PreferencesDialogPanel.class);
        if (selectedPanel == null) {
            selectedPanel = prefs.getString(PREFS_HISTORY_PANEL_KEY, null);
        }
        if ((c = (Component)preferencesPanel.scrollerMap.get(selectedPanel)) != null) {
            preferencesPanel.tabbedPane.setSelectedComponent(c);
        }
        JPanel resetPanel = new JPanel(new FlowLayout(0));
        JButton resetPreferencesButton = new JButton(new AbstractAction("Reset preferences..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialogPanel.handleResetPreferences(preferencesPanel);
            }
        });
        resetPanel.add(resetPreferencesButton);
        holder.add((Component)resetPanel, "South");
        JOptionPane op = new JOptionPane(holder, -1, 2);
        JDialog dlg = op.createDialog(editorKit.getWorkspace(), "Preferences");
        dlg.setResizable(true);
        dlg.setVisible(true);
        if (!preferencesPanel.wasReset) {
            int ret;
            Object o = op.getValue();
            if (o != null && (ret = ((Integer)o).intValue()) == 0) {
                preferencesPanel.applyPreferences();
            }
            prefs.putString(PREFS_HISTORY_PANEL_KEY, preferencesPanel.getSelectedPanel());
        }
        preferencesPanel.dispose();
    }

    private static void handleResetPreferences(PreferencesDialogPanel panel) {
        int ret = JOptionPane.showConfirmDialog(panel, RESET_PREFERENCES_CONFIRMATION_DIALOG_MESSAGE, RESET_PREFERENCES_CONFIRMATION_DIALOG_TITLE, 0, 2);
        if (ret == 0) {
            PreferencesManager.getInstance().resetPreferencesToFactorySettings();
            panel.wasReset = true;
        }
    }
}

