/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.menu;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.action.ProtegeDynamicAction;
import org.protege.editor.core.ui.menu.MenuActionPlugin;
import org.protege.editor.core.ui.menu.MenuActionPluginLoader;

public class MenuBuilder {
    private static final Logger logger = Logger.getLogger(MenuBuilder.class);
    private EditorKit editorKit;
    private Set<ProtegeAction> actions;
    private Map<MenuActionPlugin, Set<MenuActionPlugin>> parentChildMap;
    private Map<String, ButtonGroup> group2ButtonGroupMap;

    public MenuBuilder(EditorKit editorKit) {
        this.editorKit = editorKit;
        this.parentChildMap = new HashMap<MenuActionPlugin, Set<MenuActionPlugin>>();
        this.group2ButtonGroupMap = new HashMap<String, ButtonGroup>();
        this.actions = new HashSet<ProtegeAction>();
    }

    public JMenuBar buildMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.parentChildMap.clear();
        Map<String, MenuActionPlugin> idPluginMap = this.getPlugins();
        for (MenuActionPlugin plugin : idPluginMap.values()) {
            MenuActionPlugin parent = idPluginMap.get(plugin.getParentId());
            this.getChildren(parent).add(plugin);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("" + parent + " parent of " + plugin));
        }
        List<MenuActionPlugin> topLevelMenus = MenuBuilder.getSortedList(this.getChildren(null));
        for (MenuActionPlugin plugin : topLevelMenus) {
            this.addMenu(plugin, menuBar);
        }
        return menuBar;
    }

    private void addMenu(MenuActionPlugin plugin, JComponent menuContainer) {
        this.logCreateMenu(plugin, menuContainer);
        List<MenuActionPlugin> children = MenuBuilder.getSortedList(this.getChildren(plugin));
        if (!children.isEmpty()) {
            this.buildCompositeMenu(plugin, menuContainer, children);
        } else if (plugin.isDynamic()) {
            this.buildDynamicMenu(plugin, menuContainer);
        } else if (this.hasParentMenu(plugin)) {
            this.buildInnerMenu(plugin, menuContainer);
        } else {
            this.buildTopLevelMenu(plugin, menuContainer);
        }
    }

    private void buildCompositeMenu(MenuActionPlugin plugin, JComponent menuContainer, List<MenuActionPlugin> children) {
        JMenu menu = new JMenu(plugin.getName());
        menuContainer.add(menu);
        MenuActionPlugin lastPlugin = null;
        for (MenuActionPlugin childPlugin : children) {
            if (lastPlugin != null && !lastPlugin.getGroup().equals(childPlugin.getGroup())) {
                menu.addSeparator();
            }
            this.addMenu(childPlugin, menu);
            lastPlugin = childPlugin;
        }
    }

    private void buildDynamicMenu(MenuActionPlugin plugin, JComponent menuContainer) {
        JMenu menu = new JMenu(plugin.getName());
        menuContainer.add(menu);
        try {
            ProtegeDynamicAction action = (ProtegeDynamicAction)plugin.newInstance();
            this.invokeDynamicMenuMethods(action, menu);
            menu.addMenuListener(this.getDynamicMenuListener(menu, action));
            this.actions.add(action);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void buildInnerMenu(MenuActionPlugin plugin, JComponent menuContainer) {
        try {
            ProtegeAction action = (ProtegeAction)plugin.newInstance();
            JMenuItem menuItem = this.createMenuItem(plugin, action);
            KeyStroke ks = plugin.getAccelerator();
            ks = this.fixAcceleratorForMacOSX(ks);
            menuItem.setAccelerator(ks);
            menuContainer.add(menuItem);
            this.invokeInnerMenuMethods(action, menuItem, menuContainer);
            this.actions.add(action);
        }
        catch (Exception e) {
            ProtegeApplication.getErrorLog().logError(e);
        }
        catch (NoClassDefFoundError noClass) {
            logger.error((Object)("Error loading menu plugin " + plugin.getId() + "(" + plugin.getName() + ")"));
            ProtegeApplication.getErrorLog().logError(noClass);
        }
    }

    private void buildTopLevelMenu(MenuActionPlugin plugin, JComponent menuContainer) {
        JMenu menu = new JMenu(plugin.getName());
        menuContainer.add(menu);
    }

    private JMenuItem createMenuItem(MenuActionPlugin plugin, ProtegeAction action) {
        if (plugin.isCheckBox()) {
            return new JCheckBoxMenuItem(action);
        }
        if (plugin.isRadioButton()) {
            JRadioButtonMenuItem radioButtonMenuItem = new JRadioButtonMenuItem(action);
            ButtonGroup group = this.getButtonGroup(plugin);
            if (group != null) {
                group.add(radioButtonMenuItem);
            }
            return radioButtonMenuItem;
        }
        return new JMenuItem(action);
    }

    private ButtonGroup getButtonGroup(MenuActionPlugin plugin) {
        String group = plugin.getGroup();
        if (group == null) {
            return null;
        }
        ButtonGroup buttonGroup = this.group2ButtonGroupMap.get(group);
        if (buttonGroup == null) {
            buttonGroup = new ButtonGroup();
            this.group2ButtonGroupMap.put(group, buttonGroup);
        }
        return buttonGroup;
    }

    private KeyStroke fixAcceleratorForMacOSX(KeyStroke ks) {
        if (ks != null && ks.getKeyCode() == 127 && OSUtils.isOSX()) {
            ks = KeyStroke.getKeyStroke(8, ks.getModifiers());
        }
        return ks;
    }

    private MenuListener getDynamicMenuListener(final JMenu menu, final ProtegeDynamicAction action) {
        return new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                menu.removeAll();
                action.rebuildChildMenuItems(menu);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        };
    }

    private void invokeDynamicMenuMethods(ProtegeDynamicAction action, JMenu menu) {
        block2: {
            try {
                Method m = action.getClass().getMethod("setMenu", JMenu.class);
                m.invoke((Object)action, menu);
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("Action " + action + " is not requesting a menu item" + t));
            }
        }
    }

    private void invokeInnerMenuMethods(ProtegeAction action, JMenuItem menuItem, JComponent menuContainer) {
        block5: {
            Method m;
            block4: {
                try {
                    m = action.getClass().getMethod("setMenuItem", JMenuItem.class);
                    m.invoke((Object)action, menuItem);
                }
                catch (Throwable t) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("Action " + action + " is not requesting a menu item" + t));
                }
            }
            try {
                m = action.getClass().getMethod("setMenuParent", JComponent.class);
                m.invoke((Object)action, menuContainer);
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)("Action " + action + " is not requesting its parent" + t));
            }
        }
    }

    private Map<String, MenuActionPlugin> getPlugins() {
        HashMap<String, MenuActionPlugin> result = new HashMap<String, MenuActionPlugin>();
        MenuActionPluginLoader pluginLoader = new MenuActionPluginLoader(this.editorKit);
        for (MenuActionPlugin plugin : pluginLoader.getPlugins()) {
            result.put(plugin.getId(), plugin);
        }
        return result;
    }

    private Set<MenuActionPlugin> getChildren(MenuActionPlugin plugin) {
        Set<MenuActionPlugin> children = this.parentChildMap.get(plugin);
        if (children == null) {
            children = new HashSet<MenuActionPlugin>();
            this.parentChildMap.put(plugin, children);
        }
        return children;
    }

    private static List<MenuActionPlugin> getSortedList(Set<MenuActionPlugin> plugins) {
        ArrayList<MenuActionPlugin> list = new ArrayList<MenuActionPlugin>(plugins);
        Collections.sort(list, new MenuActionPluginComparator());
        return list;
    }

    private boolean hasParentMenu(MenuActionPlugin plugin) {
        return plugin.getParentId().length() > 0;
    }

    public Set<ProtegeAction> getActions() {
        return this.actions;
    }

    private void logCreateMenu(MenuActionPlugin plugin, JComponent menuContainer) {
        if (logger.isDebugEnabled()) {
            if (menuContainer instanceof JMenuBar) {
                logger.debug((Object)("Adding " + plugin + " to menu bar"));
            } else if (menuContainer instanceof JMenu) {
                logger.debug((Object)("Giving " + ((JMenu)menuContainer).getText() + " the child " + plugin));
            } else {
                logger.debug((Object)"Modify this log message, please");
            }
        }
    }

    private static class MenuActionPluginComparator
    implements Comparator<MenuActionPlugin> {
        private MenuActionPluginComparator() {
        }

        @Override
        public int compare(MenuActionPlugin o1, MenuActionPlugin o2) {
            int result = o1.getGroup().compareTo(o2.getGroup());
            if (result == 0) {
                result = o1.getGroupIndex().compareTo(o2.getGroupIndex());
            }
            return result;
        }
    }
}

