/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.ui.about.PluginInfoTable;
import org.protege.editor.core.ui.util.Icons;

public class AboutPanel
extends JPanel {
    private static final long serialVersionUID = 6652956832712711211L;

    public AboutPanel() {
        this.setLayout(new BorderLayout());
        JPanel pluginPanel = new JPanel(new BorderLayout());
        pluginPanel.add(new JScrollPane(new PluginInfoTable()));
        pluginPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Plugin information"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.add(pluginPanel);
        JPanel logoPanel = new JPanel(new BorderLayout(3, 3));
        JLabel logoLabel = new JLabel(Icons.getIcon("logo.banner.gif"));
        logoPanel.add((Component)logoLabel, "North");
        BundleContext applicationContext = PluginUtilities.getInstance().getApplicationContext();
        Bundle application = applicationContext.getBundle();
        Version v = PluginUtilities.getBundleVersion(application);
        String build = PluginUtilities.getBuildNumber(application);
        String versionString = "Version " + v.getMajor() + "." + v.getMinor() + "." + v.getMicro() + " (Build " + build + ")";
        JLabel label = new JLabel(versionString, 0);
        logoPanel.add((Component)label, "South");
        logoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 20, 5));
        this.add((Component)logoPanel, "North");
        JLabel copy = new JLabel("<html><body>Protege is a collaborative development effort between Stanford University and University of Manchester.<br><br>Protege-OWL 4 and Protege-Core Framework Copyright (c) The University of Manchester 2006");
        copy.setFont(copy.getFont().deriveFont(10.0f));
        copy.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        this.add((Component)copy, "South");
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    public static void showDialog() {
        JOptionPane.showMessageDialog(null, new AboutPanel(), "About", -1);
    }
}

