/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.platform.apple;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Logger;

public abstract class AbstractAppleApplicationWrapper {
    private static Logger log = Logger.getLogger(AbstractAppleApplicationWrapper.class);
    private Object application;
    private Object listener;
    private Class<?> applicationClass;
    private Class<?> applicationListenerClass;
    private Class<?> applicationEventClass;
    private Method getApplicationMethod;
    private Method addApplicationListenerMethod;
    private Method handleAboutMethod;
    private Method handleOpenFileMethod;
    private Method handlePreferencesMethod;
    private Method handleQuitMethod;
    private Method getFileNameMethod;
    private Method setHandledMethod;

    public AbstractAppleApplicationWrapper() {
        try {
            this.getClassesAndInterfaces();
            this.application = this.getApplicationMethod.invoke(null, new Object[0]);
            this.addApplicationListenerMethod.invoke(this.application, this.getListener());
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize OS X specific settings");
        }
    }

    private void getClassesAndInterfaces() throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        this.applicationClass = Class.forName("com.apple.eawt.Application");
        this.applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
        this.applicationEventClass = Class.forName("com.apple.eawt.ApplicationEvent");
        this.getApplicationMethod = this.applicationClass.getMethod("getApplication", new Class[0]);
        this.addApplicationListenerMethod = this.applicationClass.getMethod("addApplicationListener", this.applicationListenerClass);
        this.addApplicationListenerMethod = this.applicationClass.getMethod("addApplicationListener", this.applicationListenerClass);
        this.handleAboutMethod = this.applicationListenerClass.getMethod("handleAbout", this.applicationEventClass);
        this.handleOpenFileMethod = this.applicationListenerClass.getMethod("handleOpenFile", this.applicationEventClass);
        this.handlePreferencesMethod = this.applicationListenerClass.getMethod("handlePreferences", this.applicationEventClass);
        this.handleQuitMethod = this.applicationListenerClass.getMethod("handleQuit", this.applicationEventClass);
        this.getFileNameMethod = this.applicationEventClass.getMethod("getFilename", new Class[0]);
        this.setHandledMethod = this.applicationEventClass.getMethod("setHandled", Boolean.TYPE);
    }

    private Object getListener() {
        if (this.listener != null) {
            return this.listener;
        }
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object applicationEvent;
                if (method.equals(AbstractAppleApplicationWrapper.this.handleAboutMethod)) {
                    applicationEvent = args[0];
                    AbstractAppleApplicationWrapper.this.setHandledMethod.invoke(applicationEvent, AbstractAppleApplicationWrapper.this.handleAboutRequest());
                }
                if (method.equals(AbstractAppleApplicationWrapper.this.handleOpenFileMethod)) {
                    Object event = args[0];
                    String fileName = (String)AbstractAppleApplicationWrapper.this.getFileNameMethod.invoke(event, new Object[0]);
                    AbstractAppleApplicationWrapper.this.editFile(fileName);
                } else if (method.equals(AbstractAppleApplicationWrapper.this.handlePreferencesMethod)) {
                    applicationEvent = args[0];
                    AbstractAppleApplicationWrapper.this.setHandledMethod.invoke(applicationEvent, AbstractAppleApplicationWrapper.this.handlePreferencesRequest());
                } else if (method.equals(AbstractAppleApplicationWrapper.this.handleQuitMethod)) {
                    applicationEvent = args[0];
                    AbstractAppleApplicationWrapper.this.setHandledMethod.invoke(applicationEvent, AbstractAppleApplicationWrapper.this.handleQuitRequest());
                } else {
                    if (method.getName().equals("equals")) {
                        return proxy == args[0];
                    }
                    if (method.getName().equals("hashCode")) {
                        return 42;
                    }
                    if (method.getName().equals("toString")) {
                        return "OSX Application Listener";
                    }
                }
                return null;
            }
        };
        this.listener = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.applicationListenerClass}, handler);
        return this.listener;
    }

    protected final void setEnabledPreferencesMenu(boolean enabled) {
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            Method setEnabledPreferencesMenu = applicationClass.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            setEnabledPreferencesMenu.invoke(this.application, enabled);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void editFile(String var1) throws Exception;

    protected abstract boolean handlePreferencesRequest();

    protected abstract boolean handleAboutRequest();

    protected abstract boolean handleQuitRequest();
}

