/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.editorkit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.protege.editor.core.editorkit.EditorKitFactoryPlugin;

public class RecentEditorKitManager {
    private static final Logger logger = Logger.getLogger(RecentEditorKitManager.class);
    private static RecentEditorKitManager instance;
    private List<EditorKitDescriptor> editorKitDescriptors = new ArrayList<EditorKitDescriptor>();
    public static final String RECENT_EDITOR_KITS_FILE_NAME = "RecentEditorKits";
    public static final int MAX_EDITOR_KITS = 10;
    public static final String PREFERENCES_KEY = "org.protege.editor.owl.recenteditorkits";

    private RecentEditorKitManager() {
    }

    public static synchronized RecentEditorKitManager getInstance() {
        if (instance == null) {
            instance = new RecentEditorKitManager();
        }
        return instance;
    }

    public void dispose() {
        instance = null;
    }

    public List<EditorKitDescriptor> getDescriptors() {
        return new ArrayList<EditorKitDescriptor>(this.editorKitDescriptors);
    }

    public void pruneInvalidDescriptors() {
        for (EditorKitFactoryPlugin plugin : ProtegeManager.getInstance().getEditorKitFactoryPlugins()) {
            EditorKitFactory factory = plugin.newInstance();
            Iterator<EditorKitDescriptor> it = this.editorKitDescriptors.iterator();
            while (it.hasNext()) {
                if (factory.isValidDescriptor(it.next())) continue;
                it.remove();
            }
        }
    }

    public void clear() {
        this.editorKitDescriptors.clear();
    }

    public void add(EditorKitDescriptor editorKitDescriptor) {
        Iterator<EditorKitDescriptor> it = this.editorKitDescriptors.iterator();
        while (it.hasNext()) {
            EditorKitDescriptor descriptor = it.next();
            if (!descriptor.equals(editorKitDescriptor)) continue;
            it.remove();
            break;
        }
        this.editorKitDescriptors.add(0, editorKitDescriptor);
        int i = 9;
        while (this.editorKitDescriptors.size() > 10) {
            this.editorKitDescriptors.remove(i);
        }
        this.save();
    }

    public void load() {
        Preferences userRoot = Preferences.userRoot();
        byte[] prefsBytes = userRoot.getByteArray(PREFERENCES_KEY, null);
        if (prefsBytes == null) {
            return;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(prefsBytes));
            this.editorKitDescriptors = (List)ois.readObject();
            ois.close();
            this.pruneInvalidDescriptors();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void save() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this.editorKitDescriptors);
            oos.flush();
            oos.close();
            Preferences userRoot = Preferences.userRoot();
            userRoot.putByteArray(PREFERENCES_KEY, bos.toByteArray());
            userRoot.flush();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (BackingStoreException e) {
            logger.error((Object)e);
        }
    }
}

