/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Font;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTheme;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.protege.editor.core.BookMarkedURIManager;
import org.protege.editor.core.BundleManager;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ProtegeProperties;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitFactoryPlugin;
import org.protege.editor.core.editorkit.EditorKitManager;
import org.protege.editor.core.editorkit.RecentEditorKitManager;
import org.protege.editor.core.platform.OSGi;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.platform.PlatformArguments;
import org.protege.editor.core.platform.apple.ProtegeAppleApplication;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.error.ErrorLog;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.progress.BackgroundTaskManager;
import org.protege.editor.core.ui.util.ProtegePlasticTheme;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.update.PluginManager;

public class ProtegeApplication
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(ProtegeApplication.class);
    public static final String RUN_ONCE = "PROTEGE_OSGI_RUN_ONCE";
    public static final String ID = "org.protege.editor.core.application";
    public static final String LOOK_AND_FEEL_KEY = "LOOK_AND_FEEL_KEY";
    public static final String LOOK_AND_FEEL_CLASS_NAME = "LOOK_AND_FEEL_CLASS_NAME";
    private static BundleContext context;
    private static BundleManager bundleManager;
    private List<URI> commandLineURIs;
    private static ErrorLog errorLog;
    private static BackgroundTaskManager backgroundTaskManager;
    private static boolean quitting;

    public void start(BundleContext context) {
        try {
            ProtegeApplication.context = context;
            this.displayPlatform();
            this.initApplication();
            if (OSUtils.isOSX()) {
                ProtegeAppleApplication.getInstance();
            }
            ProtegeManager.getInstance().initialise(this);
            this.startApplication();
        }
        catch (Throwable t) {
            logger.error((Object)"Exception caught starting Protege", t);
        }
    }

    public void stop(BundleContext context) throws Exception {
        BookMarkedURIManager.getInstance().dispose();
        RecentEditorKitManager.getInstance().save();
        RecentEditorKitManager.getInstance().dispose();
        PluginUtilities.getInstance().dispose();
        ProtegeManager.getInstance().dispose();
    }

    private void displayPlatform() {
        Bundle b = context.getBundle();
        Version v = PluginUtilities.getBundleVersion(b);
        logger.info((Object)("Starting Protege 4 OWL Editor (Version " + v.getMajor() + "." + v.getMinor() + "." + v.getMicro() + ", Build = " + PluginUtilities.getBuildNumber(b) + ")"));
        logger.info((Object)"Platform:");
        logger.info((Object)("    Java: JVM " + System.getProperty("java.runtime.version") + " Memory: " + Runtime.getRuntime().maxMemory() / 1000000L + "M"));
        logger.info((Object)("    Language: " + Locale.getDefault().getLanguage() + ", Country: " + Locale.getDefault().getCountry()));
        logger.info((Object)("    Framework: " + context.getProperty("org.osgi.framework.vendor") + " (" + context.getProperty("org.osgi.framework.version") + ")"));
        logger.info((Object)("    OS: " + context.getProperty("org.osgi.framework.os.name") + " (" + context.getProperty("org.osgi.framework.os.version") + ")"));
        logger.info((Object)("    Processor: " + context.getProperty("org.osgi.framework.processor")));
    }

    protected ProtegeApplication initApplication() throws Exception {
        PluginUtilities.getInstance().initialise(context);
        ProtegeApplication.loadDefaults();
        ProtegeApplication.initializeLookAndFeel();
        ProtegeApplication.checkConfiguration();
        ProtegeApplication.setupExceptionHandler();
        this.loadPlugins();
        this.processCommandLineURIs();
        ProtegeApplication.loadRecentEditorKits();
        return this;
    }

    private static void loadDefaults() {
        ProtegeProperties.getInstance().put("org.protege.classcolor", "CC9F2A");
        ProtegeProperties.getInstance().put("org.protege.propertycolor", "306FA2");
        ProtegeProperties.getInstance().put("org.protege.objectpropertycolor", "306FA2");
        ProtegeProperties.getInstance().put("org.protege.datapropertycolor", "6B8E23");
        ProtegeProperties.getInstance().put("org.protege.individualcolor", "541852");
        ProtegeProperties.getInstance().put("org.protege.ontologycolor", "6B47A2");
        ProtegeProperties.getInstance().put("org.protege.annotationscolor", "719FA0");
        ProtegeProperties.getInstance().put("org.protege.datatypecolor", "6B8E23  ");
        ProtegeProperties.getInstance().put("org.protege.classcategory", "Class");
        ProtegeProperties.getInstance().put("org.protege.objectpropertycategory", "Object property");
        ProtegeProperties.getInstance().put("org.protege.datapropertycategory", "Data property");
        ProtegeProperties.getInstance().put("org.protege.annotationpropertycategory", "Annotation property");
        ProtegeProperties.getInstance().put("org.protege.individualcategory", "Individual");
        ProtegeProperties.getInstance().put("org.protege.datatypecategory", "Datatype");
        ProtegeProperties.getInstance().put("org.protege.ontologycategory", "Ontology");
        ProtegeProperties.getInstance().put("org.protege.querycategory", "Query");
    }

    private static void loadRecentEditorKits() {
        RecentEditorKitManager.getInstance().load();
    }

    private static void initializeLookAndFeel() {
        if (System.getProperty("swing.defaultlaf") == null) {
            String defaultLAFClassName = OSUtils.isOSX() ? UIManager.getSystemLookAndFeelClassName() : "com.jgoodies.looks.plastic.PlasticLookAndFeel";
            Preferences p = PreferencesManager.getInstance().getApplicationPreferences(LOOK_AND_FEEL_KEY);
            String lafClsName = p.getString(LOOK_AND_FEEL_CLASS_NAME, defaultLAFClassName);
            try {
                if (lafClsName.equals("com.jgoodies.looks.plastic.PlasticLookAndFeel")) {
                    ProtegeApplication.setProtegeDefaultLookAndFeel(lafClsName);
                } else {
                    UIManager.setLookAndFeel(lafClsName);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private static void setProtegeDefaultLookAndFeel(String lafName) {
        try {
            LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(lafName).newInstance();
            PopupFactory.setSharedInstance(new PopupFactory());
            PlasticLookAndFeel.setCurrentTheme((MetalTheme)((Object)new ProtegePlasticTheme()));
            PlasticLookAndFeel.setTabStyle((String)"metal");
            FontSet fontSet = FontSets.createDefaultFontSet((Font)ProtegePlasticTheme.DEFAULT_FONT);
            FontPolicy fixedPolicy = FontPolicies.createFixedPolicy((FontSet)fontSet);
            PlasticLookAndFeel.setFontPolicy((FontPolicy)fixedPolicy);
            UIManager.put("ClassLoader", lookAndFeel.getClass().getClassLoader());
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)("Look and feel not found: " + lafName));
        }
        catch (Exception e) {
            logger.warn((Object)e.toString());
        }
    }

    private static void checkConfiguration() {
        Logger rootLogger = Logger.getRootLogger();
        if (rootLogger.isDebugEnabled()) {
            JOptionPane.showMessageDialog(null, "Logger not initialized.\nThis could have a major impact on performance.\nUse the -Dlog4j.configuration=\"file:/...\" jvm option.", "Performance Issue Detected", 2);
        }
    }

    private static void setupExceptionHandler() {
        errorLog = new ErrorLog();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                errorLog.uncaughtException(t, e);
                logger.warn((Object)("Uncaught Exception in thread " + t.getName()), e);
            }
        });
    }

    private void loadPlugins() {
        bundleManager = new BundleManager(context);
        bundleManager.loadPlugins();
    }

    private void processCommandLineURIs() {
        try {
            this.commandLineURIs = new ArrayList<URI>();
            for (String arg : PlatformArguments.getArguments(context)) {
                File f = new File(arg);
                if (f.exists()) {
                    this.commandLineURIs.add(f.toURI());
                    continue;
                }
                try {
                    URI uri = new URI(arg);
                    this.commandLineURIs.add(uri);
                }
                catch (URISyntaxException e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (Throwable t) {
            logger.warn((Object)("Error processing command line arguments " + t));
        }
    }

    private void startApplication() throws Exception {
        this.createAndSetupDefaultEditorKit();
        if (this.commandLineURIs != null && !this.commandLineURIs.isEmpty()) {
            for (URI uri : this.commandLineURIs) {
                this.editURI(uri);
            }
        }
        this.checkForUpdates();
    }

    private void checkForUpdates() {
        if (PluginManager.getInstance().isAutoUpdateEnabled()) {
            PluginManager.getInstance().performAutoUpdate();
            context.addFrameworkListener(new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 1) {
                        context.removeFrameworkListener((FrameworkListener)this);
                    }
                }
            });
        }
    }

    private void createAndSetupDefaultEditorKit() {
        try {
            ProtegeManager pm = ProtegeManager.getInstance();
            List<EditorKitFactoryPlugin> editorKitFactoryPlugins = pm.getEditorKitFactoryPlugins();
            if (editorKitFactoryPlugins.isEmpty()) {
                throw new RuntimeException("No editor kit factory plugins available");
            }
            EditorKitFactoryPlugin defaultPlugin = editorKitFactoryPlugins.get(0);
            pm.createAndSetupNewEditorKit(defaultPlugin);
        }
        catch (Exception e) {
            ErrorLogPanel.showErrorDialog(e);
        }
    }

    public static BundleContext getContext() {
        return context;
    }

    public static ErrorLog getErrorLog() {
        return errorLog;
    }

    public static BackgroundTaskManager getBackgroundTaskManager() {
        return backgroundTaskManager;
    }

    public static BundleManager getBundleManager() {
        return bundleManager;
    }

    public static boolean handleQuit() {
        quitting = true;
        EditorKitManager eKitMngr = ProtegeManager.getInstance().getEditorKitManager();
        for (EditorKit eKit : eKitMngr.getEditorKits()) {
            Workspace wSpace = eKit.getWorkspace();
            if (eKitMngr.getWorkspaceManager().doClose(wSpace)) continue;
            quitting = false;
            return quitting;
        }
        try {
            boolean forceExit = !OSGi.systemExitHandledByLauncher();
            context.getBundle(0L).stop();
            if (forceExit) {
                Thread.sleep(1000L);
                System.exit(0);
            }
        }
        catch (Throwable t) {
            logger.fatal((Object)"Exception caught trying to shut down Protege.", t);
        }
        return true;
    }

    public void handleClose() {
        EditorKitManager eKitMngr;
        if (!quitting && (eKitMngr = ProtegeManager.getInstance().getEditorKitManager()).getEditorKitCount() == 0) {
            ProtegeApplication.handleQuit();
        }
    }

    public void editURI(URI uri) throws Exception {
        ProtegeManager pm = ProtegeManager.getInstance();
        for (EditorKitFactoryPlugin plugin : pm.getEditorKitFactoryPlugins()) {
            if (!plugin.newInstance().canLoad(uri)) continue;
            pm.loadAndSetupEditorKitFromURI(plugin, uri);
            break;
        }
    }

    public static void handleRestart() {
    }

    static {
        errorLog = new ErrorLog();
        backgroundTaskManager = new BackgroundTaskManager();
        quitting = false;
    }
}

