/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class);

    public static void copyFileToDirectory(File file, File directory) throws IOException {
        FileUtils.copyFile(file, directory);
    }

    public static void copyFile(File inputFile, File outputFile) throws IOException {
        if (inputFile.isDirectory()) {
            throw new IOException("Cannot copy file: " + inputFile + " as this is a directory");
        }
        if (outputFile.isDirectory()) {
            outputFile = new File(outputFile, inputFile.getName());
        }
        outputFile.getParentFile().mkdirs();
        outputFile.createNewFile();
        FileInputStream in = new FileInputStream(inputFile);
        FileOutputStream out = new FileOutputStream(outputFile);
        FileChannel inc = in.getChannel();
        FileChannel outc = out.getChannel();
        inc.transferTo(0L, inc.size(), outc);
        inc.close();
        outc.close();
        in.close();
        out.close();
    }

    public static void showFile(File file) throws IOException {
        if (System.getProperty("os.name").indexOf("Mac") != -1) {
            FileUtils.showInFinder(file);
        } else if (System.getProperty("os.name").indexOf("Windows") != -1) {
            FileUtils.showInExplorer(file);
        } else {
            logger.debug((Object)("showFile not implemented for " + System.getProperty("os.name")));
        }
    }

    private static void showInFinder(File file) throws IOException {
        String[] params = new String[]{"osascript", "-e", "set p to \"" + file.getCanonicalPath() + "\"", "-e", "tell application \"Finder\"", "-e", "reveal (POSIX file p) as alias", "-e", "activate", "-e", "end tell"};
        Runtime.getRuntime().exec(params);
    }

    private static void showInExplorer(File file) throws IOException {
        String path = file.getCanonicalPath();
        if (path.indexOf(" ") != -1) {
            path = "\"" + path + "\"";
        }
        String[] params = new String[]{"explorer", "/n,/select," + path};
        Runtime.getRuntime().exec(params);
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                FileUtils.deleteRecursively(f);
            }
        }
        file.delete();
    }

    public static File createTempFile(File targetFile) throws IOException {
        String targetName = targetFile.getName();
        int extensionIndex = targetName.lastIndexOf(".");
        String filename = targetName.substring(0, extensionIndex);
        for (int i = filename.length(); i < 3; ++i) {
            filename = filename + "_";
        }
        return File.createTempFile(filename, targetName.substring(extensionIndex));
    }
}

