/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ModelManager;

public abstract class AbstractModelManager
implements ModelManager {
    private static final Logger logger = Logger.getLogger(AbstractModelManager.class);
    private Map<Object, Disposable> objects = new HashMap<Object, Disposable>();

    protected AbstractModelManager() {
    }

    @Override
    public <T extends Disposable> void put(Object key, T object) {
        this.objects.put(key, object);
    }

    @Override
    public <T extends Disposable> T get(Object key) {
        return (T)this.objects.get(key);
    }

    @Override
    public void dispose() {
        for (Disposable object : this.objects.values()) {
            try {
                object.dispose();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        this.objects.clear();
    }
}

