/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.rdf.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.openrdf.repository.RepositoryException;
import org.protege.owl.rdf.api.OwlTripleStore;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class SynchronizeTripleStoreListener
implements OWLOntologyChangeListener {
    private Logger LOGGER = Logger.getLogger(SynchronizeTripleStoreListener.class);
    private OwlTripleStore ots;

    public SynchronizeTripleStoreListener(OwlTripleStore ots) {
        this.ots = ots;
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            try {
                if (oWLOntologyChange instanceof AddAxiom) {
                    this.ots.addAxiom(oWLOntologyChange.getOntology().getOntologyID(), ((AddAxiom)oWLOntologyChange).getAxiom());
                    continue;
                }
                if (!(oWLOntologyChange instanceof RemoveAxiom)) continue;
                this.ots.removeAxiom(oWLOntologyChange.getOntology().getOntologyID(), ((RemoveAxiom)oWLOntologyChange).getAxiom());
            }
            catch (RepositoryException re) {
                this.LOGGER.warn((Object)"Exception caught makeing change", (Throwable)re);
            }
        }
    }
}

