/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.rdf.impl;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.coode.owlapi.rdf.model.AbstractTranslator;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.protege.owl.rdf.impl.RepositoryRuntimeException;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFTranslator
extends AbstractTranslator<Value, Resource, URI, Literal> {
    public static final Logger LOGGER = Logger.getLogger(RDFTranslator.class);
    private URI axiomResource;
    private Map<Object, BNode> bnodeMap = new IdentityHashMap<Object, BNode>();
    private ValueFactory rdfFactory;
    private RepositoryConnection connection;

    public static void translate(Repository repository, OWLAxiom axiom, URI hashCodeProperty, URI sourceOntologyProperty, URI ontologyRepresentative) throws RepositoryException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting axiom parse");
        }
        boolean success = false;
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        RDFTranslator translator = null;
        try {
            OWLOntology ontology = RDFTranslator.createOntology(manager, axiom);
            translator = new RDFTranslator(repository, manager, ontology);
            ValueFactory rdfFactory = repository.getValueFactory();
            RepositoryConnection connection = translator.getConnection();
            axiom.accept((OWLObjectVisitor)translator);
            for (OWLEntity entity : axiom.getSignature()) {
                connection.add((Resource)rdfFactory.createURI(entity.getIRI().toString()), rdfFactory.createURI(OWLRDFVocabulary.RDF_TYPE.getIRI().toString()), (Value)rdfFactory.createURI(entity.getEntityType().getVocabulary().getIRI().toString()), new Resource[]{translator.axiomResource});
            }
            Literal hashCodeValue = rdfFactory.createLiteral(axiom.hashCode());
            connection.add((Resource)translator.axiomResource, hashCodeProperty, (Value)hashCodeValue, new Resource[0]);
            connection.add((Resource)translator.axiomResource, sourceOntologyProperty, (Value)ontologyRepresentative, new Resource[0]);
        }
        catch (RepositoryRuntimeException rre) {
            throw rre.getCause();
        }
        catch (OWLOntologyCreationException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (translator != null) {
                translator.close(success);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Finished axiom parse");
        }
    }

    private static OWLOntology createOntology(OWLOntologyManager manager, OWLAxiom axiom) throws OWLOntologyCreationException {
        OWLOntology ontology = manager.createOntology();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(ontology, axiom));
        manager.applyChanges(changes);
        return ontology;
    }

    private RDFTranslator(Repository repository, OWLOntologyManager manager, OWLOntology ontology) throws RepositoryException {
        super(manager, ontology, false);
        this.rdfFactory = repository.getValueFactory();
        this.axiomResource = this.rdfFactory.createURI("http://protege.org/owl2triplestore.owl/" + UUID.randomUUID().toString().replace('-', '_'));
        this.connection = repository.getConnection();
    }

    public void close(boolean success) throws RepositoryException {
        if (success) {
            this.connection.commit();
        } else {
            this.connection.rollback();
        }
        this.connection.close();
    }

    public RepositoryConnection getConnection() {
        return this.connection;
    }

    public URI getAxiomResource() {
        return this.axiomResource;
    }

    protected URI getResourceNode(IRI iri) {
        return this.rdfFactory.createURI(iri.toString());
    }

    protected URI getPredicateNode(IRI iri) {
        return this.rdfFactory.createURI(iri.toString());
    }

    protected BNode getAnonymousNode(Object key) {
        BNode node = this.bnodeMap.get(key);
        if (node == null) {
            node = this.rdfFactory.createBNode();
            this.bnodeMap.put(key, node);
        }
        return node;
    }

    protected Literal getLiteralNode(OWLLiteral literal) {
        if (literal.isRDFPlainLiteral() && literal.getLang() != null) {
            return this.rdfFactory.createLiteral(literal.getLiteral(), literal.getLang());
        }
        if (literal.isRDFPlainLiteral()) {
            return this.rdfFactory.createLiteral(literal.getLiteral());
        }
        return this.rdfFactory.createLiteral(literal.getLiteral(), this.rdfFactory.createURI(literal.getDatatype().getIRI().toString()));
    }

    protected void addTriple(Resource subject, URI pred, Value object) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Inserting triple into graph with name " + this.axiomResource));
                LOGGER.debug((Object)("\t" + subject + ", " + pred + ", " + object));
            }
            this.connection.add(subject, pred, object, new Resource[]{this.axiomResource});
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException(e);
        }
    }
}

