/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.rdf.impl;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.coode.owlapi.rdfxml.parser.AnonymousNodeChecker;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.rdfxml.RDFXMLWriter;
import org.protege.owl.rdf.api.OwlTripleStore;
import org.protege.owl.rdf.impl.AnonymousResourceHandler;
import org.protege.owl.rdf.impl.RDFTranslator;
import org.protege.owl.rdf.impl.TrackingOntologyFormat;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.rdf.syntax.RDFConsumer;
import org.xml.sax.SAXException;

public class OwlTripleStoreImpl
implements OwlTripleStore {
    public static final Logger LOGGER = Logger.getLogger(OwlTripleStoreImpl.class);
    public static final String NS = "http://protege.org/owl2triplestore.owl";
    public static final String HASH_CODE = "http://protege.org/owl2triplestore.owl#hashCode";
    public static final String SOURCE_ONTOLOGY = "http://protege.org/owl2triplestore.owl#sourceOntology";
    public static final String ONTOLOGY_ID = "http://protege.org/owl2triplestore.owl#ontologyId";
    public static final String ONTOLOGY_VERSION = "http://protege.org/owl2triplestore.owl#ontologyVersion";
    public static final String BNODE_PREFIX = "_:BNode";
    private URI hashCodeProperty;
    private URI sourceOntologyProperty;
    private URI ontologyIdProperty;
    private URI ontologyVersionProperty;
    private Repository repository;
    private AnonymousResourceHandler anonymousHandler;
    private AnonymousNodeChecker anonymousNodeChecker = new AnonymousNodeChecker(){

        public boolean isAnonymousNode(IRI iri) {
            return iri.toString().startsWith(OwlTripleStoreImpl.BNODE_PREFIX);
        }

        public boolean isAnonymousSharedNode(String iri) {
            return false;
        }

        public boolean isAnonymousNode(String iri) {
            return false;
        }
    };

    public OwlTripleStoreImpl(Repository repository, OWLDataFactory factory) {
        this.repository = repository;
        ValueFactory rdfFactory = repository.getValueFactory();
        this.hashCodeProperty = rdfFactory.createURI(HASH_CODE);
        this.sourceOntologyProperty = rdfFactory.createURI(SOURCE_ONTOLOGY);
        this.ontologyIdProperty = rdfFactory.createURI(ONTOLOGY_ID);
        this.ontologyVersionProperty = rdfFactory.createURI(ONTOLOGY_VERSION);
        this.anonymousHandler = new AnonymousResourceHandler(factory);
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void addAxiom(OWLOntologyID ontologyId, OWLAxiom axiom) throws RepositoryException {
        axiom = this.anonymousHandler.insertSurrogates(axiom);
        URI ontologyRepresentative = this.getOntologyRepresentative(ontologyId);
        if (this.getAxiomId(ontologyId, axiom) != null) {
            return;
        }
        RDFTranslator.translate(this.repository, axiom, this.hashCodeProperty, this.sourceOntologyProperty, ontologyRepresentative);
    }

    @Override
    public void removeAxiom(OWLOntologyID ontologyId, OWLAxiom axiom) throws RepositoryException {
        URI axiomResource = this.getAxiomId(ontologyId, axiom = this.anonymousHandler.insertSurrogates(axiom));
        if (axiomResource != null) {
            this.removeAxiom(axiomResource);
        }
    }

    @Override
    public boolean hasAxiom(OWLOntologyID ontologyId, OWLAxiom axiom) throws RepositoryException {
        return this.getAxiomId(ontologyId, axiom = this.anonymousHandler.insertSurrogates(axiom)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<OWLAxiom, RepositoryException> listAxioms(OWLOntologyID ontologyId) throws RepositoryException {
        URI ontologyRepresentative = this.getOntologyRepresentative(ontologyId);
        RepositoryConnection connection = this.repository.getConnection();
        boolean success = false;
        try {
            final RepositoryResult stmts = connection.getStatements(null, this.sourceOntologyProperty, (Value)ontologyRepresentative, false, new Resource[0]);
            CloseableIteration<OWLAxiom, RepositoryException> it = new CloseableIteration<OWLAxiom, RepositoryException>(){

                public boolean hasNext() throws RepositoryException {
                    return stmts.hasNext();
                }

                public OWLAxiom next() throws RepositoryException {
                    Statement stmt = (Statement)stmts.next();
                    URI axiomResource = (URI)stmt.getSubject();
                    RepositoryConnection connection = OwlTripleStoreImpl.this.repository.getConnection();
                    try {
                        OWLAxiom oWLAxiom = OwlTripleStoreImpl.this.anonymousHandler.removeSurrogates(OwlTripleStoreImpl.this.parseAxiom(connection, axiomResource));
                        return oWLAxiom;
                    }
                    catch (RepositoryException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        throw new RepositoryException((Throwable)e);
                    }
                    finally {
                        connection.close();
                    }
                }

                public void remove() throws RepositoryException {
                    stmts.remove();
                }

                public void close() throws RepositoryException {
                    stmts.close();
                }
            };
            success = true;
            CloseableIteration<OWLAxiom, RepositoryException> closeableIteration = it;
            return closeableIteration;
        }
        finally {
            if (!success) {
                connection.close();
            }
        }
    }

    @Override
    public boolean integrityCheck() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public boolean incorporateExternalChanges() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI getAxiomId(OWLOntologyID ontologyId, OWLAxiom axiom) throws RepositoryException {
        URI ontologyRepresentative = this.getOntologyRepresentative(ontologyId);
        ValueFactory factory = this.repository.getValueFactory();
        RepositoryConnection connection = this.repository.getConnection();
        try {
            Literal hashCodeValue = factory.createLiteral(axiom.hashCode());
            RepositoryResult correctHashCodes = connection.getStatements(null, this.hashCodeProperty, (Value)hashCodeValue, false, new Resource[0]);
            try {
                while (true) {
                    if (correctHashCodes.hasNext()) {
                        URI axiomId;
                        Statement stmt = (Statement)correctHashCodes.next();
                        if (!(stmt.getSubject() instanceof URI) || !connection.hasStatement((Resource)(axiomId = (URI)stmt.getSubject()), this.sourceOntologyProperty, (Value)ontologyRepresentative, false, new Resource[0]) || !axiom.equals(this.parseAxiom(connection, axiomId))) continue;
                        URI uRI = axiomId;
                        return uRI;
                        continue;
                    }
                    break;
                }
            }
            finally {
                correctHashCodes.close();
            }
            URI uRI = null;
            return uRI;
        }
        catch (Exception ooce) {
            throw new RepositoryException((Throwable)ooce);
        }
        finally {
            connection.close();
        }
    }

    private OWLAxiom parseAxiom(RepositoryConnection connection, URI axiomId) throws OWLOntologyCreationException, RepositoryException, SAXException, IOException, RDFHandlerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting parse");
        }
        OWLRDFConsumer consumer = this.consumeTriples(connection, axiomId);
        consumer.endModel();
        OWLOntology ontology = consumer.getOntology();
        OWLAxiom result = null;
        if (ontology.getAxiomCount() == 1) {
            result = (OWLAxiom)ontology.getAxioms().iterator().next();
        } else if (ontology.getAxiomCount() > 1) {
            for (OWLAxiom axiom : ontology.getAxioms()) {
                if (axiom instanceof OWLDeclarationAxiom) continue;
                result = axiom;
                break;
            }
        }
        return result;
    }

    @Override
    public OWLClassExpression parseClassExpression(BNode classExpressionNode) throws RepositoryException {
        RepositoryConnection connection = this.repository.getConnection();
        try {
            RepositoryResult triples = connection.getStatements((Resource)classExpressionNode, null, null, false, new Resource[0]);
            Statement stmt = (Statement)triples.next();
            URI axiomId = (URI)stmt.getContext();
            OWLRDFConsumer consumer = this.consumeTriples(connection, axiomId);
            String nodeName = this.generateName((Resource)classExpressionNode);
            OWLClassExpression ce = consumer.translateClassExpression(IRI.create((String)nodeName));
            consumer.endModel();
            if (!((TrackingOntologyFormat)consumer.getOntologyFormat()).getFailed()) {
                OWLClassExpression oWLClassExpression = ce;
                return oWLClassExpression;
            }
            OWLClassExpression oWLClassExpression = null;
            return oWLClassExpression;
        }
        catch (Exception e) {
            if (e instanceof RepositoryException) {
                throw (RepositoryException)((Object)e);
            }
            throw new RepositoryException((Throwable)e);
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OWLRDFConsumer consumeTriples(RepositoryConnection connection, URI axiomId) throws OWLOntologyCreationException, RepositoryException, IOException, RDFHandlerException, SAXException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = manager.createOntology();
        OWLRDFConsumer consumer = new OWLRDFConsumer(ontology, this.anonymousNodeChecker, new OWLOntologyLoaderConfiguration());
        consumer.setOntologyFormat((RDFOntologyFormat)new TrackingOntologyFormat());
        RepositoryResult triples = connection.getStatements(null, null, null, false, new Resource[]{axiomId});
        try {
            RDFXMLWriter writer = null;
            if (LOGGER.isDebugEnabled()) {
                File tmp = File.createTempFile("owl2triples", ".owl");
                writer = new RDFXMLWriter((Writer)new FileWriter(tmp));
                LOGGER.debug((Object)("Writing to " + tmp));
                writer.startRDF();
            }
            while (triples.hasNext()) {
                Statement stmt = (Statement)triples.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)stmt);
                    writer.handleStatement(stmt);
                }
                String subjectName = this.generateName(stmt.getSubject());
                String predicateName = this.generateName((Resource)stmt.getPredicate());
                if (stmt.getObject() instanceof Literal) {
                    this.addTriple((RDFConsumer)consumer, subjectName, predicateName, (Literal)stmt.getObject());
                    continue;
                }
                this.addTriple((RDFConsumer)consumer, subjectName, predicateName, (Resource)stmt.getObject());
            }
            if (LOGGER.isDebugEnabled()) {
                writer.endRDF();
                LOGGER.debug((Object)("Parse complete - " + ontology.getAxioms()));
            }
        }
        finally {
            triples.close();
        }
        return consumer;
    }

    private void addTriple(RDFConsumer consumer, String subjectName, String predicateName, Literal literal) throws SAXException {
        String datatype = literal.getDatatype() == null ? null : literal.getDatatype().stringValue();
        consumer.statementWithLiteralValue(subjectName, predicateName, literal.stringValue(), literal.getLanguage(), datatype);
    }

    private void addTriple(RDFConsumer consumer, String subjectName, String predicateName, Resource value) throws SAXException {
        consumer.statementWithResourceValue(subjectName, predicateName, this.generateName(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAxiom(URI axiomResource) throws RepositoryException {
        if (axiomResource == null) {
            return;
        }
        RepositoryConnection connection = this.repository.getConnection();
        RepositoryResult stmts = null;
        try {
            stmts = connection.getStatements(null, null, null, false, new Resource[]{axiomResource});
            connection.remove((Iteration)stmts, new Resource[]{axiomResource});
        }
        finally {
            if (stmts != null) {
                stmts.close();
            }
            connection.close();
        }
    }

    private String generateName(Resource resource) {
        String name = resource instanceof BNode ? BNODE_PREFIX + ((BNode)resource).getID() : resource.stringValue();
        return name;
    }

    private URI getOntologyRepresentative(OWLOntologyID id) throws RepositoryException {
        if (id.isAnonymous()) {
            return this.repository.getValueFactory().createURI(this.anonymousHandler.getSurrogateId(id).toString());
        }
        return this.getNamedOntologyRepresentative(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI getNamedOntologyRepresentative(OWLOntologyID id) throws RepositoryException {
        URI result = null;
        RepositoryConnection connection = this.repository.getConnection();
        try {
            URI rdfId = this.repository.getValueFactory().createURI(id.getOntologyIRI().toString());
            URI rdfVersion = id.getVersionIRI() != null ? this.repository.getValueFactory().createURI(id.getVersionIRI().toString()) : null;
            RepositoryResult idStatements = connection.getStatements(null, this.ontologyIdProperty, (Value)rdfId, false, new Resource[0]);
            try {
                while (idStatements.hasNext()) {
                    Statement idStatement = (Statement)idStatements.next();
                    URI possible = (URI)idStatement.getSubject();
                    RepositoryResult versionStatements = connection.getStatements((Resource)possible, this.ontologyVersionProperty, null, false, new Resource[0]);
                    try {
                        if (rdfVersion == null && !versionStatements.hasNext()) {
                            result = possible;
                        } else {
                            while (versionStatements.hasNext()) {
                                Statement versionStatement = (Statement)versionStatements.next();
                                if (!versionStatement.getObject().equals(rdfVersion)) continue;
                                result = possible;
                                break;
                            }
                            if (result == null) continue;
                        }
                        break;
                    }
                    finally {
                        versionStatements.close();
                    }
                }
            }
            finally {
                idStatements.close();
            }
            if (result == null) {
                result = this.createNamedOntologyRepresentative(rdfId, rdfVersion);
            }
        }
        finally {
            connection.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI createNamedOntologyRepresentative(URI rdfId, URI rdfVersion) throws RepositoryException {
        String uriString = "http://protege.org/owl2triplestore.owl#" + UUID.randomUUID().toString().replaceAll("-", "_");
        URI representative = this.repository.getValueFactory().createURI(uriString);
        RepositoryConnection connection = this.repository.getConnection();
        try {
            connection.add((Resource)representative, this.ontologyIdProperty, (Value)rdfId, new Resource[0]);
            if (rdfVersion != null) {
                connection.add((Resource)representative, this.ontologyVersionProperty, (Value)rdfVersion, new Resource[0]);
            }
        }
        finally {
            connection.close();
        }
        return representative;
    }
}

