/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owl.rdf.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class AnonymousResourceHandler {
    public static final String ANONYMOUS_SURROGATE_PREFIX = "urn:AnonId:";
    private OWLDataFactory factory;
    private TreeMap<OWLOntologyID, IRI> ontologyIdToSurrogateIdMap = new TreeMap();
    private TreeMap<IRI, OWLOntologyID> surrogateIdToOntologyId = new TreeMap();
    private TreeMap<OWLAnonymousIndividual, IRI> anonymousIndividualToIRIMap = new TreeMap();
    private TreeMap<IRI, OWLAnonymousIndividual> iriToAnonymousIndividualMap = new TreeMap();

    public AnonymousResourceHandler(OWLDataFactory factory) {
        this.factory = factory;
    }

    public IRI getSurrogateId(OWLOntologyID id) {
        IRI result = this.ontologyIdToSurrogateIdMap.get(id);
        if (id.isAnonymous() && result == null) {
            result = this.createSurrogate();
            this.addSurrogateOntologyId(id, result);
        }
        return result;
    }

    public OWLOntologyID getOntologyID(IRI iri) {
        OWLOntologyID id = this.surrogateIdToOntologyId.get(iri);
        if (id == null && this.isSurrogate(iri)) {
            id = new OWLOntologyID();
            this.addSurrogateOntologyId(id, iri);
        }
        return id;
    }

    public IRI getSurrogateId(OWLAnonymousIndividual i) {
        IRI result = this.anonymousIndividualToIRIMap.get(i);
        if (result == null) {
            result = this.createSurrogate();
            this.addSurrogateIndividual(i, result);
        }
        return result;
    }

    public OWLAnonymousIndividual getAnonymousIndividual(IRI iri) {
        OWLAnonymousIndividual i = this.iriToAnonymousIndividualMap.get(iri);
        if (i == null) {
            i = this.factory.getOWLAnonymousIndividual();
            this.addSurrogateIndividual(i, iri);
        }
        return i;
    }

    public OWLAxiom removeSurrogates(OWLAxiom axiom) {
        return (OWLAxiom)new SurrogateRemover(this.factory).duplicateObject((OWLObject)axiom);
    }

    public OWLAxiom insertSurrogates(OWLAxiom axiom) {
        return (OWLAxiom)new SurrogateInserter(this.factory).duplicateObject((OWLObject)axiom);
    }

    public boolean isSurrogate(IRI iri) {
        return iri.toString().startsWith(ANONYMOUS_SURROGATE_PREFIX);
    }

    private void addSurrogateOntologyId(OWLOntologyID id, IRI iri) {
        this.ontologyIdToSurrogateIdMap.put(id, iri);
        this.surrogateIdToOntologyId.put(iri, id);
    }

    private void addSurrogateIndividual(OWLAnonymousIndividual i, IRI iri) {
        this.anonymousIndividualToIRIMap.put(i, iri);
        this.iriToAnonymousIndividualMap.put(iri, i);
    }

    private IRI createSurrogate() {
        UUID id = UUID.randomUUID();
        String idString = id.toString().replaceAll("-", "_");
        return IRI.create((String)(ANONYMOUS_SURROGATE_PREFIX + idString));
    }

    private Set<OWLAnnotation> duplicateAxiomAnnotations(OWLAxiom axiom, OWLObjectDuplicator duplicator) {
        HashSet<OWLAnnotation> duplicatedAnnos = new HashSet<OWLAnnotation>();
        for (OWLAnnotation anno : axiom.getAnnotations()) {
            duplicatedAnnos.add((OWLAnnotation)duplicator.duplicateObject((OWLObject)anno));
        }
        return duplicatedAnnos;
    }

    private class SurrogateRemover
    extends OWLObjectDuplicator {
        public SurrogateRemover(OWLDataFactory factory) {
            super(factory);
        }

        public void visit(OWLNamedIndividual i) {
            if (AnonymousResourceHandler.this.isSurrogate(i.getIRI())) {
                this.setLastObject(AnonymousResourceHandler.this.getAnonymousIndividual(i.getIRI()));
            } else {
                this.setLastObject(i);
            }
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            OWLAnnotationSubject subject = (OWLAnnotationSubject)this.duplicateObject((OWLObject)axiom.getSubject());
            OWLAnnotationProperty prop = (OWLAnnotationProperty)this.duplicateObject((OWLObject)axiom.getProperty());
            OWLAnnotationValue value = (OWLAnnotationValue)this.duplicateObject((OWLObject)axiom.getValue());
            if (value instanceof IRI && AnonymousResourceHandler.this.isSurrogate((IRI)value)) {
                value = AnonymousResourceHandler.this.getAnonymousIndividual((IRI)value);
            }
            this.setLastObject(AnonymousResourceHandler.this.factory.getOWLAnnotationAssertionAxiom(prop, subject, value, AnonymousResourceHandler.this.duplicateAxiomAnnotations((OWLAxiom)axiom, this)));
        }

        public void visit(OWLAnnotation node) {
            node.getProperty().accept((OWLObjectVisitor)this);
            OWLAnnotationProperty prop = (OWLAnnotationProperty)this.duplicateObject((OWLObject)node.getProperty());
            OWLAnnotationValue val = (OWLAnnotationValue)this.duplicateObject((OWLObject)node.getValue());
            if (val instanceof IRI && AnonymousResourceHandler.this.isSurrogate((IRI)val)) {
                val = AnonymousResourceHandler.this.getAnonymousIndividual((IRI)val);
            }
            this.setLastObject(AnonymousResourceHandler.this.factory.getOWLAnnotation(prop, val));
        }
    }

    private class SurrogateInserter
    extends OWLObjectDuplicator {
        public SurrogateInserter(OWLDataFactory factory) {
            super(factory);
        }

        public void visit(OWLAnonymousIndividual i) {
            IRI iri = AnonymousResourceHandler.this.getSurrogateId(i);
            this.setLastObject(AnonymousResourceHandler.this.factory.getOWLNamedIndividual(iri));
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            OWLAnnotationSubject subject = (OWLAnnotationSubject)this.duplicateObject((OWLObject)axiom.getSubject());
            OWLAnnotationProperty prop = (OWLAnnotationProperty)this.duplicateObject((OWLObject)axiom.getProperty());
            OWLObject rawValue = this.duplicateObject((OWLObject)axiom.getValue());
            Object value = rawValue instanceof OWLNamedIndividual ? ((OWLNamedIndividual)rawValue).getIRI() : (OWLAnnotationValue)rawValue;
            this.setLastObject(AnonymousResourceHandler.this.factory.getOWLAnnotationAssertionAxiom(prop, subject, value, AnonymousResourceHandler.this.duplicateAxiomAnnotations((OWLAxiom)axiom, this)));
        }

        public void visit(OWLAnnotation node) {
            OWLAnnotationProperty prop = (OWLAnnotationProperty)this.duplicateObject((OWLObject)node.getProperty());
            OWLObject rawValue = this.duplicateObject((OWLObject)node.getValue());
            Object val = rawValue instanceof OWLNamedIndividual ? ((OWLNamedIndividual)rawValue).getIRI() : (OWLAnnotationValue)rawValue;
            this.setLastObject(AnonymousResourceHandler.this.factory.getOWLAnnotation(prop, val));
        }
    }
}

