/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owlapi.model.OWLAxiom;
import uk.ac.manchester.cs.owl.explanation.JustificationManager;
import uk.ac.manchester.cs.owl.explanation.JustificationType;
import uk.ac.manchester.cs.owl.explanation.WorkbenchSettings;

public class WorkbenchManager {
    private WorkbenchSettings workbenchSettings = new WorkbenchSettings();
    private JustificationManager justificationManager;
    private OWLAxiom entailment;

    public WorkbenchManager(JustificationManager justificationManager, OWLAxiom entailment) {
        this.justificationManager = justificationManager;
        this.entailment = entailment;
    }

    public WorkbenchSettings getWorkbenchSettings() {
        return this.workbenchSettings;
    }

    public OWLAxiom getEntailment() {
        return this.entailment;
    }

    public Set<Explanation<OWLAxiom>> getJustifications(OWLAxiom entailment) {
        JustificationType justificationType = this.workbenchSettings.getJustificationType();
        return this.justificationManager.getJustifications(entailment, justificationType);
    }

    public int getJustificationCount(OWLAxiom entailment) {
        JustificationType justificationType = this.workbenchSettings.getJustificationType();
        return this.justificationManager.getComputedExplanationCount(entailment, justificationType);
    }

    public JustificationManager getJustificationManager() {
        return this.justificationManager;
    }

    public int getPopularity(OWLAxiom axiom) {
        int count = 0;
        Set<Explanation<OWLAxiom>> justifications = this.justificationManager.getJustifications(this.entailment, this.workbenchSettings.getJustificationType());
        for (Explanation<OWLAxiom> justification : justifications) {
            if (!justification.contains(axiom)) continue;
            ++count;
        }
        return count;
    }
}

