/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.api.ExplanationManager;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.checker.InconsistentOntologyExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.impl.laconic.LaconicExplanationGeneratorFactory;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import uk.ac.manchester.cs.owl.explanation.CachingRootDerivedGenerator;
import uk.ac.manchester.cs.owl.explanation.ExplanationManagerListener;
import uk.ac.manchester.cs.owl.explanation.JustificationCache;
import uk.ac.manchester.cs.owl.explanation.JustificationCacheManager;
import uk.ac.manchester.cs.owl.explanation.JustificationGeneratorProgressDialog;
import uk.ac.manchester.cs.owl.explanation.JustificationType;
import uk.ac.manchester.cs.owl.explanation.OWLReasonerProvider;
import uk.ac.manchester.cs.owl.explanation.ProtegeOWLReasonerFactoryWrapper;

public class JustificationManager
implements Disposable,
OWLReasonerProvider {
    private ExecutorService executorService;
    private final OWLOntologyChangeListener ontologyChangeListener;
    public static final String KEY = "uk.ac.manchester.cs.owl.explanation";
    private OWLModelManager modelManager;
    private CachingRootDerivedGenerator rootDerivedGenerator;
    private List<ExplanationManagerListener> listeners;
    private int explanationLimit;
    private boolean findAllExplanations;
    private JustificationCacheManager justificationCacheManager = new JustificationCacheManager();
    private JustificationGeneratorProgressDialog progressDialog;

    private JustificationManager(OWLModelManager modelManager) {
        this.modelManager = modelManager;
        this.rootDerivedGenerator = new CachingRootDerivedGenerator(modelManager);
        this.listeners = new ArrayList<ExplanationManagerListener>();
        this.explanationLimit = 2;
        this.findAllExplanations = true;
        this.progressDialog = new JustificationGeneratorProgressDialog(new JFrame());
        this.executorService = Executors.newSingleThreadExecutor();
        this.ontologyChangeListener = new OWLOntologyChangeListener(){

            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
                JustificationManager.this.justificationCacheManager.clear();
            }
        };
        modelManager.addOntologyChangeListener(this.ontologyChangeListener);
    }

    public OWLReasonerProvider getReasonerProvider() {
        return this;
    }

    public OWLReasonerFactory getReasonerFactory() {
        return new ProtegeOWLReasonerFactoryWrapper(this.modelManager.getOWLReasonerManager().getCurrentReasonerFactory());
    }

    public int getExplanationLimit() {
        return this.explanationLimit;
    }

    public void setExplanationLimit(int explanationLimit) {
        this.explanationLimit = explanationLimit;
        this.fireExplanationLimitChanged();
    }

    public boolean isFindAllExplanations() {
        return this.findAllExplanations;
    }

    public void setFindAllExplanations(boolean findAllExplanations) {
        this.findAllExplanations = findAllExplanations;
        this.fireExplanationLimitChanged();
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.modelManager.getReasoner();
    }

    public int getComputedExplanationCount(OWLAxiom entailment, JustificationType type) {
        JustificationCache cache = this.justificationCacheManager.getJustificationCache(type);
        if (cache.contains(entailment)) {
            return cache.get(entailment).size();
        }
        return -1;
    }

    public Set<Explanation<OWLAxiom>> getJustifications(OWLAxiom entailment, JustificationType type) throws ExplanationException {
        JustificationCache cache = this.justificationCacheManager.getJustificationCache(type);
        if (!cache.contains(entailment)) {
            Set<Explanation<OWLAxiom>> expls = this.computeJustifications(entailment, type);
            cache.put(expls);
        }
        return cache.get(entailment);
    }

    public Explanation<OWLAxiom> getLaconicJustification(Explanation<OWLAxiom> explanation) {
        Set<Explanation<OWLAxiom>> explanations = this.getLaconicExplanations(explanation, 1);
        if (explanations.isEmpty()) {
            return Explanation.getEmptyExplanation((Object)explanation.getEntailment());
        }
        return explanations.iterator().next();
    }

    private Set<Explanation<OWLAxiom>> computeJustifications(OWLAxiom entailment, JustificationType justificationType) throws ExplanationException {
        HashSet axioms = new HashSet();
        for (OWLOntology ont : this.modelManager.getActiveOntologies()) {
            axioms.addAll(ont.getAxioms());
        }
        ExplanationGeneratorCallable callable = new ExplanationGeneratorCallable(axioms, entailment, justificationType);
        try {
            this.executorService.submit(callable);
        }
        catch (ExplanationGeneratorInterruptedException e) {
            System.err.println("Explanation generator terminated early by user");
        }
        this.progressDialog.reset();
        this.progressDialog.setVisible(true);
        HashSet<Explanation<OWLAxiom>> explanations = new HashSet<Explanation<OWLAxiom>>(callable.found);
        this.fireExplanationsComputed(entailment);
        return explanations;
    }

    private ExplanationGeneratorFactory<OWLAxiom> getCurrentExplanationGeneratorFactory(JustificationType type) {
        OWLReasoner reasoner = this.modelManager.getOWLReasonerManager().getCurrentReasoner();
        if (reasoner.isConsistent()) {
            if (type.equals((Object)JustificationType.LACONIC)) {
                OWLReasonerFactory rf = this.getReasonerFactory();
                return ExplanationManager.createLaconicExplanationGeneratorFactory((OWLReasonerFactory)rf, this.progressDialog.getProgressMonitor());
            }
            OWLReasonerFactory rf = this.getReasonerFactory();
            return ExplanationManager.createExplanationGeneratorFactory((OWLReasonerFactory)rf, this.progressDialog.getProgressMonitor());
        }
        if (type.equals((Object)JustificationType.LACONIC)) {
            OWLReasonerFactory rf = this.getReasonerFactory();
            InconsistentOntologyExplanationGeneratorFactory fac = new InconsistentOntologyExplanationGeneratorFactory(rf, Long.MAX_VALUE);
            return new LaconicExplanationGeneratorFactory((ExplanationGeneratorFactory)fac);
        }
        OWLReasonerFactory rf = this.getReasonerFactory();
        return new InconsistentOntologyExplanationGeneratorFactory(rf, Long.MAX_VALUE);
    }

    public OWLOntologyManager getExplanationOntologyManager() {
        return this.modelManager.getOWLOntologyManager();
    }

    public Set<Explanation<OWLAxiom>> getLaconicExplanations(Explanation<OWLAxiom> explanation, int limit) throws ExplanationException {
        return this.computeLaconicExplanations(explanation, limit);
    }

    private Set<Explanation<OWLAxiom>> computeLaconicExplanations(Explanation<OWLAxiom> explanation, int limit) throws ExplanationException {
        try {
            if (this.modelManager.getReasoner().isConsistent()) {
                OWLReasonerFactory rf = this.getReasonerFactory();
                ExplanationGenerator g = ExplanationManager.createLaconicExplanationGeneratorFactory((OWLReasonerFactory)rf).createExplanationGenerator(explanation.getAxioms());
                return g.getExplanations(explanation.getEntailment(), limit);
            }
            OWLReasonerFactory rf = this.getReasonerFactory();
            InconsistentOntologyExplanationGeneratorFactory fac = new InconsistentOntologyExplanationGeneratorFactory(rf, Long.MAX_VALUE);
            LaconicExplanationGeneratorFactory lacFac = new LaconicExplanationGeneratorFactory((ExplanationGeneratorFactory)fac);
            ExplanationGenerator g = lacFac.createExplanationGenerator(explanation.getAxioms());
            return g.getExplanations(explanation.getEntailment(), limit);
        }
        catch (ExplanationException e) {
            throw new ExplanationException((Throwable)e);
        }
    }

    public void dispose() {
        this.rootDerivedGenerator.dispose();
        this.modelManager.removeOntologyChangeListener(this.ontologyChangeListener);
    }

    public void addListener(ExplanationManagerListener lsnr) {
        this.listeners.add(lsnr);
    }

    public void removeListener(ExplanationManagerListener lsnr) {
        this.listeners.remove(lsnr);
    }

    protected void fireExplanationLimitChanged() {
        for (ExplanationManagerListener lsnr : new ArrayList<ExplanationManagerListener>(this.listeners)) {
            lsnr.explanationLimitChanged(this);
        }
    }

    protected void fireExplanationsComputed(OWLAxiom entailment) {
        for (ExplanationManagerListener lsnr : new ArrayList<ExplanationManagerListener>(this.listeners)) {
            lsnr.explanationsComputed(entailment);
        }
    }

    public static synchronized JustificationManager getExplanationManager(OWLModelManager modelManager) {
        JustificationManager m = (JustificationManager)modelManager.get((Object)KEY);
        if (m == null) {
            m = new JustificationManager(modelManager);
            modelManager.put((Object)KEY, (Disposable)m);
        }
        return m;
    }

    private class ExplanationGeneratorCallable
    implements Callable<Set<Explanation<OWLAxiom>>>,
    ExplanationProgressMonitor<OWLAxiom> {
        private Set<OWLAxiom> axioms;
        private OWLAxiom axiom;
        private int limit = Integer.MAX_VALUE;
        private Set<Explanation<OWLAxiom>> found = new HashSet<Explanation<OWLAxiom>>();
        private JustificationType justificationType;

        private ExplanationGeneratorCallable(Set<OWLAxiom> axioms, OWLAxiom axiom, JustificationType justificationType) {
            this.axioms = axioms;
            this.axiom = axiom;
            this.justificationType = justificationType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Explanation<OWLAxiom>> call() throws Exception {
            block3: {
                this.found.clear();
                ExplanationGeneratorFactory factory = JustificationManager.this.getCurrentExplanationGeneratorFactory(this.justificationType);
                ExplanationGenerator delegate = factory.createExplanationGenerator(this.axioms, (ExplanationProgressMonitor)this);
                JustificationManager.this.progressDialog.reset();
                try {
                    if (JustificationManager.this.findAllExplanations) {
                        delegate.getExplanations((Object)this.axiom);
                        break block3;
                    }
                    delegate.getExplanations((Object)this.axiom, this.limit);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JustificationManager.this.progressDialog.setVisible(false);
                        }
                    });
                    throw throwable;
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return this.found;
        }

        public void foundExplanation(ExplanationGenerator<OWLAxiom> explanationGenerator, Explanation<OWLAxiom> explanation, Set<Explanation<OWLAxiom>> explanations) {
            JustificationManager.this.progressDialog.getProgressMonitor().foundExplanation(explanationGenerator, explanation, explanations);
            this.found.add(explanation);
        }

        public boolean isCancelled() {
            return JustificationManager.this.progressDialog.getProgressMonitor().isCancelled();
        }
    }
}

