/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.util.Comparator;
import java.util.List;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.manchester.cs.owl.explanation.JustificationFormattingManager;
import uk.ac.manchester.cs.owl.explanation.JustificationFrameSectionRow;

public class JustificationFrameSection
extends AbstractOWLFrameSection<Explanation<OWLAxiom>, OWLAxiom, OWLAxiom> {
    private static String LABEL = "Explanation for: ";
    private boolean filled = false;

    public JustificationFrameSection(OWLEditorKit editorKit, OWLFrame<? extends Explanation<OWLAxiom>> owlFrame) {
        super(editorKit, LABEL, owlFrame);
    }

    public String getLabel() {
        Explanation explanation = (Explanation)this.getRootObject();
        if (explanation == null) {
            return "";
        }
        OWLModelManager modelManager = this.getOWLEditorKit().getOWLModelManager();
        String rendering = modelManager.getRendering((OWLObject)explanation.getEntailment()).replaceAll("\\s+", " ");
        return LABEL + rendering;
    }

    protected OWLAxiom createAxiom(OWLAxiom object) {
        return object;
    }

    public OWLObjectEditor<OWLAxiom> getObjectEditor() {
        return null;
    }

    protected void refill(OWLOntology ontology) {
        if (this.filled) {
            return;
        }
        this.filled = true;
        JustificationFormattingManager formattingManager = JustificationFormattingManager.getManager();
        Explanation expl = (Explanation)this.getRootObject();
        List<OWLAxiom> formatting = formattingManager.getOrdering(expl);
        for (OWLAxiom ax : formatting) {
            int depth = formattingManager.getIndentation(expl, ax);
            JustificationFrameSectionRow row = new JustificationFrameSectionRow(this.getOWLEditorKit(), (OWLFrameSection<Explanation<OWLAxiom>, OWLAxiom, OWLAxiom>)this, (Explanation<OWLAxiom>)expl, ax, depth);
            this.addRow((OWLFrameSectionRow)row);
        }
    }

    protected void clear() {
        this.filled = false;
    }

    public Comparator<OWLFrameSectionRow<Explanation<OWLAxiom>, OWLAxiom, OWLAxiom>> getRowComparator() {
        return null;
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canAcceptDrop(List<OWLObject> objects) {
        return false;
    }
}

