/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owlapi.model.OWLAxiom;

public class JustificationCache {
    private Map<OWLAxiom, Set<Explanation<OWLAxiom>>> cache = new HashMap<OWLAxiom, Set<Explanation<OWLAxiom>>>();

    public boolean contains(OWLAxiom entailment) {
        return this.cache.containsKey(entailment);
    }

    public Set<Explanation<OWLAxiom>> get(OWLAxiom entailment) {
        Set<Explanation<OWLAxiom>> explanations = this.cache.get(entailment);
        if (explanations == null) {
            return Collections.emptySet();
        }
        return new HashSet<Explanation<OWLAxiom>>(explanations);
    }

    public void put(Explanation<OWLAxiom> explanation) {
        Set<Explanation<OWLAxiom>> expls = this.cache.get(explanation.getEntailment());
        if (expls == null) {
            expls = new HashSet<Explanation<OWLAxiom>>();
            this.cache.put((OWLAxiom)explanation.getEntailment(), expls);
        }
        expls.add(explanation);
    }

    public void put(Set<Explanation<OWLAxiom>> explanations) {
        for (Explanation<OWLAxiom> expl : explanations) {
            this.put(expl);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public void clear(OWLAxiom entailment) {
        this.cache.remove(entailment);
    }
}

