/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.awt.Component;
import java.io.File;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.CollectionFactory;

public class ExplanationUtil {
    public static void saveExplanationAsOntology(OWLEditorKit editorKit, Explanation explanation) throws OWLOntologyCreationException, OWLOntologyChangeException, OWLOntologyStorageException {
        File f = UIUtil.saveFile((Component)((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)editorKit.getWorkspace())), (String)"Save ontology as", (Set)CollectionFactory.createSet((Object[])new String[]{"owl", "txt", "rdf"}), (String)"JustificationExtract.owl");
        if (f == null) {
            return;
        }
        OWLOntologyManager man = OWLManager.createOWLOntologyManager();
        OWLOntology ont = man.createOntology(explanation.getAxioms());
        OWLDataFactory df = man.getOWLDataFactory();
        IRI annotationIRI = IRI.create((String)"http://owl.cs.manchester.ac.uk/explanation/annotations/inferredAxiom");
        String entailmentRendering = editorKit.getOWLModelManager().getRendering((OWLObject)((OWLAxiom)explanation.getEntailment()));
        OWLAnnotationProperty prop = df.getOWLAnnotationProperty(annotationIRI);
        OWLAnnotation anno = df.getOWLAnnotation(prop, (OWLAnnotationValue)df.getOWLStringLiteral(entailmentRendering));
        man.applyChange((OWLOntologyChange)new AddOntologyAnnotation(ont, anno));
        man.saveOntology(ont, IRI.create((File)f));
    }
}

