/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.RootDerivedReasoner;
import org.semanticweb.owl.explanation.impl.rootderived.StructuralRootDerivedReasoner;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import uk.ac.manchester.cs.owl.explanation.ProtegeOWLReasonerFactoryWrapper;

public class CachingRootDerivedGenerator
implements RootDerivedReasoner,
Disposable,
OWLModelManagerListener,
OWLOntologyChangeListener {
    private OWLModelManager modelManager;
    private Set<OWLClass> rootUnsatClses;
    private boolean dirty = true;

    public CachingRootDerivedGenerator(OWLModelManager modelManager) {
        this.modelManager = modelManager;
        this.rootUnsatClses = new HashSet<OWLClass>();
        modelManager.addListener((OWLModelManagerListener)this);
        modelManager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        this.dirty = true;
    }

    public Set<OWLClass> getRootUnsatisfiableClasses() throws ExplanationException {
        if (this.dirty) {
            this.rootUnsatClses.clear();
            this.dirty = false;
            ProtegeOWLReasonerFactoryWrapper rf = new ProtegeOWLReasonerFactoryWrapper(this.modelManager.getOWLReasonerManager().getCurrentReasonerFactory());
            StructuralRootDerivedReasoner gen = new StructuralRootDerivedReasoner(OWLManager.createOWLOntologyManager(), this.modelManager.getReasoner(), (OWLReasonerFactory)rf);
            this.rootUnsatClses.addAll(gen.getRootUnsatisfiableClasses());
        }
        return Collections.unmodifiableSet(this.rootUnsatClses);
    }

    public Set<OWLClass> getDependentChildClasses(OWLClass owlClass) {
        return Collections.emptySet();
    }

    public Set<OWLClass> getDependentDescendantClasses(OWLClass owlClass) {
        return Collections.emptySet();
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> list) throws OWLException {
        this.dirty = true;
    }

    public void handleChange(OWLModelManagerChangeEvent event) {
        if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_CLASSIFIED)) {
            this.dirty = true;
        }
    }

    public void dispose() {
        this.modelManager.removeListener((OWLModelManagerListener)this);
        this.modelManager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
    }
}

