/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owlapi.dlsyntax;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.AbstractOWLOntologyStorer;
import uk.ac.manchester.cs.owlapi.dlsyntax.DLSyntaxObjectRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DLSyntaxOntologyStorerBase
extends AbstractOWLOntologyStorer {
    private static final long serialVersionUID = 7356203415509177158L;
    private OWLOntology ont;

    @Override
    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, Writer w, OWLOntologyFormat format) throws OWLOntologyStorageException {
        this.ont = ontology;
        PrintWriter writer = new PrintWriter(w);
        this.beginWritingOntology(ontology, writer);
        for (OWLObjectProperty oWLObjectProperty : new TreeSet<OWLObjectProperty>(ontology.getObjectPropertiesInSignature())) {
            this.write(oWLObjectProperty, ontology.getAxioms(oWLObjectProperty), writer);
        }
        for (OWLDataProperty oWLDataProperty : new TreeSet<OWLDataProperty>(ontology.getDataPropertiesInSignature())) {
            this.write(oWLDataProperty, ontology.getAxioms(oWLDataProperty), writer);
        }
        for (OWLClass oWLClass : new TreeSet<OWLClass>(ontology.getClassesInSignature())) {
            this.write(oWLClass, ontology.getAxioms(oWLClass), writer);
        }
        for (OWLNamedIndividual oWLNamedIndividual : new TreeSet<OWLNamedIndividual>(ontology.getIndividualsInSignature())) {
            this.write(oWLNamedIndividual, ontology.getAxioms(oWLNamedIndividual), writer);
        }
        this.beginWritingGeneralAxioms(ontology.getGeneralClassAxioms(), writer);
        for (OWLClassAxiom oWLClassAxiom : ontology.getGeneralClassAxioms()) {
            this.beginWritingAxiom(oWLClassAxiom, writer);
            this.writeAxiom(null, oWLClassAxiom, writer);
            this.endWritingAxiom(oWLClassAxiom, writer);
        }
        this.endWritingGeneralAxioms(ontology.getGeneralClassAxioms(), writer);
        this.endWritingOntology(ontology, writer);
        writer.flush();
    }

    private void write(OWLEntity entity, Set<? extends OWLAxiom> axioms, PrintWriter writer) {
        this.beginWritingAxioms(entity, axioms, writer);
        for (OWLAxiom oWLAxiom : new TreeSet<OWLAxiom>(axioms)) {
            this.beginWritingAxiom(oWLAxiom, writer);
            this.writeAxiom(entity, oWLAxiom, writer);
            this.endWritingAxiom(oWLAxiom, writer);
        }
        TreeSet<OWLAxiom> usages = new TreeSet<OWLAxiom>(this.ont.getReferencingAxioms(entity));
        usages.removeAll(axioms);
        this.beginWritingUsage(entity, usages, writer);
        for (OWLAxiom usage : usages) {
            if (axioms.contains(usage)) continue;
            this.beginWritingAxiom(usage, writer);
            this.writeAxiom(entity, usage, writer);
            this.endWritingAxiom(usage, writer);
        }
        this.endWritingUsage(entity, usages, writer);
        this.endWritingAxioms(entity, axioms, writer);
    }

    protected void writeAxiom(OWLEntity subject, OWLAxiom axiom, PrintWriter writer) {
        writer.write(this.getRendering(subject, axiom));
    }

    protected String getRendering(OWLEntity subject, OWLAxiom axiom) {
        DLSyntaxObjectRenderer ren = new DLSyntaxObjectRenderer();
        return ren.render(axiom);
    }

    protected void beginWritingOntology(OWLOntology ontology, PrintWriter writer) {
    }

    protected void endWritingOntology(OWLOntology ontology, PrintWriter writer) {
    }

    protected void beginWritingAxiom(OWLAxiom axiom, PrintWriter writer) {
    }

    protected void endWritingAxiom(OWLAxiom axiom, PrintWriter writer) {
    }

    protected void beginWritingAxioms(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer) {
    }

    protected void endWritingAxioms(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer) {
    }

    protected void beginWritingUsage(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer) {
    }

    protected void endWritingUsage(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer) {
    }

    protected void beginWritingGeneralAxioms(Set<? extends OWLAxiom> axioms, PrintWriter writer) {
    }

    protected void endWritingGeneralAxioms(Set<? extends OWLAxiom> axioms, PrintWriter writer) {
    }
}

