/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObject;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.SWRLVariableExtractor;
import uk.ac.manchester.cs.owl.owlapi.OWLLogicalAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLRuleImpl
extends OWLLogicalAxiomImpl
implements SWRLRule {
    private static final long serialVersionUID = -1546007912852691628L;
    private final Set<SWRLAtom> head;
    private final Set<SWRLAtom> body;
    private Set<SWRLVariable> variables;
    private Boolean containsAnonymousClassExpressions = null;
    private Set<OWLClassExpression> classAtomsPredicates;
    protected final AtomSimplifier ATOM_SIMPLIFIER = new AtomSimplifier();

    public SWRLRuleImpl(OWLDataFactory dataFactory, Set<? extends SWRLAtom> body, Set<? extends SWRLAtom> head, Collection<? extends OWLAnnotation> annotations) {
        super(dataFactory, annotations);
        this.head = new TreeSet<SWRLAtom>(head);
        this.body = new TreeSet<SWRLAtom>(body);
    }

    @Override
    public SWRLRule getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return SWRLRuleImpl.getOWLDataFactory().getSWRLRule(this.getBody(), this.getHead());
    }

    @Override
    public OWLAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return SWRLRuleImpl.getOWLDataFactory().getSWRLRule(this.getBody(), this.getHead());
    }

    public SWRLRuleImpl(OWLDataFactory dataFactory, Set<? extends SWRLAtom> body, Set<? extends SWRLAtom> head) {
        this(dataFactory, body, head, new ArrayList(0));
    }

    @Override
    public Set<SWRLVariable> getVariables() {
        if (this.variables == null) {
            HashSet<SWRLVariable> vars = new HashSet<SWRLVariable>();
            SWRLVariableExtractor extractor = new SWRLVariableExtractor();
            this.accept(extractor);
            vars.addAll(extractor.getVariables());
            this.variables = new HashSet<SWRLVariable>(vars);
        }
        return this.variables;
    }

    @Override
    public boolean containsAnonymousClassExpressions() {
        if (this.containsAnonymousClassExpressions == null) {
            for (SWRLAtom atom : this.head) {
                if (!(atom instanceof SWRLClassAtom) || !((SWRLClassAtom)atom).getPredicate().isAnonymous()) continue;
                this.containsAnonymousClassExpressions = true;
                break;
            }
            if (this.containsAnonymousClassExpressions == null) {
                for (SWRLAtom atom : this.body) {
                    if (!(atom instanceof SWRLClassAtom) || !((SWRLClassAtom)atom).getPredicate().isAnonymous()) continue;
                    this.containsAnonymousClassExpressions = true;
                    break;
                }
            }
            if (this.containsAnonymousClassExpressions == null) {
                this.containsAnonymousClassExpressions = false;
            }
        }
        return this.containsAnonymousClassExpressions;
    }

    @Override
    public Set<OWLClassExpression> getClassAtomPredicates() {
        if (this.classAtomsPredicates == null) {
            HashSet<OWLClassExpression> predicates = new HashSet<OWLClassExpression>();
            for (SWRLAtom atom : this.head) {
                if (!(atom instanceof SWRLClassAtom)) continue;
                predicates.add(((SWRLClassAtom)atom).getPredicate());
            }
            for (SWRLAtom atom : this.body) {
                if (!(atom instanceof SWRLClassAtom)) continue;
                predicates.add(((SWRLClassAtom)atom).getPredicate());
            }
            this.classAtomsPredicates = new HashSet<OWLClassExpression>(predicates);
        }
        return this.classAtomsPredicates;
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(SWRLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(SWRLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Set<SWRLAtom> getBody() {
        return CollectionFactory.getCopyOnRequestSet(this.body);
    }

    @Override
    public Set<SWRLAtom> getHead() {
        return CollectionFactory.getCopyOnRequestSet(this.head);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public SWRLRule getSimplified() {
        return (SWRLRule)this.accept(this.ATOM_SIMPLIFIER);
    }

    @Override
    public boolean isLogicalAxiom() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof SWRLRule)) {
                return false;
            }
            SWRLRule other = (SWRLRule)obj;
            return ((Object)other.getBody()).equals(this.body) && ((Object)other.getHead()).equals(this.head);
        }
        return false;
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.SWRL_RULE;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        SWRLRule other = (SWRLRule)object;
        int diff = SWRLRuleImpl.compareSets(this.getBody(), other.getBody());
        if (diff == 0) {
            diff = SWRLRuleImpl.compareSets(this.getHead(), other.getHead());
        }
        return diff;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AtomSimplifier
    implements SWRLObjectVisitorEx<SWRLObject> {
        protected AtomSimplifier() {
        }

        @Override
        public SWRLRule visit(SWRLRule node) {
            HashSet<SWRLAtom> nodebody = new HashSet<SWRLAtom>();
            for (SWRLAtom atom : node.getBody()) {
                nodebody.add((SWRLAtom)atom.accept(this));
            }
            HashSet<SWRLAtom> nodehead = new HashSet<SWRLAtom>();
            for (SWRLAtom atom : node.getHead()) {
                nodehead.add((SWRLAtom)atom.accept(this));
            }
            return OWLObjectImpl.getOWLDataFactory().getSWRLRule(nodebody, nodehead);
        }

        @Override
        public SWRLClassAtom visit(SWRLClassAtom node) {
            return node;
        }

        @Override
        public SWRLDataRangeAtom visit(SWRLDataRangeAtom node) {
            return node;
        }

        @Override
        public SWRLObjectPropertyAtom visit(SWRLObjectPropertyAtom node) {
            return node.getSimplified();
        }

        @Override
        public SWRLDataPropertyAtom visit(SWRLDataPropertyAtom node) {
            return node;
        }

        @Override
        public SWRLBuiltInAtom visit(SWRLBuiltInAtom node) {
            return node;
        }

        @Override
        public SWRLVariable visit(SWRLVariable node) {
            return node;
        }

        @Override
        public SWRLIndividualArgument visit(SWRLIndividualArgument node) {
            return node;
        }

        @Override
        public SWRLLiteralArgument visit(SWRLLiteralArgument node) {
            return node;
        }

        @Override
        public SWRLSameIndividualAtom visit(SWRLSameIndividualAtom node) {
            return node;
        }

        @Override
        public SWRLDifferentIndividualsAtom visit(SWRLDifferentIndividualsAtom node) {
            return node;
        }
    }
}

