/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.HashCode;
import org.semanticweb.owlapi.util.OWLClassExpressionCollector;
import org.semanticweb.owlapi.util.OWLObjectTypeIndexProvider;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEntityCollectionContainerCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLObjectImpl
implements OWLObject,
Serializable {
    private static final long serialVersionUID = -315085042205413768L;
    private int hashCode = 0;
    private Set<OWLEntity> signature;
    private Set<OWLAnonymousIndividual> anons;
    private static final OWLDataFactory f = new OWLDataFactoryImpl(false, false);

    public OWLObjectImpl(OWLDataFactory dataFactory) {
    }

    public static OWLDataFactory getOWLDataFactory() {
        return f;
    }

    @Override
    public Set<OWLEntity> getSignature() {
        if (this.signature == null) {
            HashSet<OWLEntity> sig = new HashSet<OWLEntity>();
            this.anons = new HashSet<OWLAnonymousIndividual>();
            OWLEntityCollectionContainerCollector collector = new OWLEntityCollectionContainerCollector(sig, this.anons);
            this.accept(collector);
            this.signature = sig;
        }
        return CollectionFactory.getCopyOnRequestSet(this.signature);
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        if (this.signature == null) {
            this.getSignature();
        }
        return CollectionFactory.getCopyOnRequestSet(this.anons);
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLClass()) continue;
            result.add(ent.asOWLClass());
        }
        return result;
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        HashSet<OWLDataProperty> result = new HashSet<OWLDataProperty>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLDataProperty()) continue;
            result.add(ent.asOWLDataProperty());
        }
        return result;
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        HashSet<OWLObjectProperty> result = new HashSet<OWLObjectProperty>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLObjectProperty()) continue;
            result.add(ent.asOWLObjectProperty());
        }
        return result;
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        HashSet<OWLNamedIndividual> result = new HashSet<OWLNamedIndividual>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLNamedIndividual()) continue;
            result.add(ent.asOWLNamedIndividual());
        }
        return result;
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        HashSet<OWLDatatype> result = new HashSet<OWLDatatype>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLDatatype()) continue;
            result.add(ent.asOWLDatatype());
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getNestedClassExpressions() {
        OWLClassExpressionCollector collector = new OWLClassExpressionCollector();
        return this.accept(collector);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj instanceof OWLObject;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = HashCode.hashCode(this);
        }
        return this.hashCode;
    }

    @Override
    public final int compareTo(OWLObject o) {
        int otherTypeIndex;
        OWLObjectTypeIndexProvider typeIndexProvider = new OWLObjectTypeIndexProvider();
        int thisTypeIndex = typeIndexProvider.getTypeIndex(this);
        int diff = thisTypeIndex - (otherTypeIndex = typeIndexProvider.getTypeIndex(o));
        if (diff == 0) {
            return this.compareObjectOfSameType(o);
        }
        return diff;
    }

    protected abstract int compareObjectOfSameType(OWLObject var1);

    public String toString() {
        return ToStringRenderer.getInstance().getRendering(this);
    }

    @Override
    public boolean isTopEntity() {
        return false;
    }

    @Override
    public boolean isBottomEntity() {
        return false;
    }

    protected static int compareSets(Set<? extends OWLObject> set1, Set<? extends OWLObject> set2) {
        TreeSet<? extends OWLObject> ss1 = set1 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set1 : new TreeSet<OWLObject>(set1);
        TreeSet<? extends OWLObject> ss2 = set2 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set2 : new TreeSet<OWLObject>(set2);
        Iterator thisIt = ss1.iterator();
        Iterator otherIt = ss2.iterator();
        for (int i = 0; i < ss1.size() && i < ss2.size(); ++i) {
            OWLObject o2;
            OWLObject o1 = (OWLObject)thisIt.next();
            int diff = o1.compareTo(o2 = (OWLObject)otherIt.next());
            if (diff == 0) continue;
            return diff;
        }
        return ss1.size() - ss2.size();
    }
}

