/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLLiteralImplNoCompression
extends OWLObjectImpl
implements OWLLiteral {
    static final Charset utf_8 = Charset.forName("UTF-8");
    private final byte[] literal;
    private final OWLDatatype datatype;
    private final String lang;
    private final int hashcode;

    public OWLLiteralImplNoCompression(OWLDataFactory dataFactory, String literal, String lang, OWLDatatype datatype) {
        super(dataFactory);
        this.literal = literal.getBytes(utf_8);
        if (lang == null || lang.length() == 0) {
            this.lang = "";
            this.datatype = datatype == null ? dataFactory.getRDFPlainLiteral() : datatype;
        } else {
            OWLDatatype rdfPlainLiteral = dataFactory.getRDFPlainLiteral();
            if (datatype != null && !rdfPlainLiteral.equals(datatype)) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.lang = lang;
            this.datatype = rdfPlainLiteral;
        }
        this.hashcode = this.getHashCode();
    }

    @Override
    public String getLiteral() {
        return new String(this.literal, utf_8);
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.datatype.equals(OWLLiteralImplNoCompression.getOWLDataFactory().getRDFPlainLiteral());
    }

    @Override
    public boolean hasLang() {
        return !this.lang.equals("");
    }

    @Override
    public boolean isInteger() {
        return this.datatype.equals(OWLLiteralImplNoCompression.getOWLDataFactory().getIntegerOWLDatatype());
    }

    @Override
    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.getLiteral());
    }

    @Override
    public boolean isBoolean() {
        return this.datatype.equals(OWLLiteralImplNoCompression.getOWLDataFactory().getBooleanOWLDatatype());
    }

    @Override
    public boolean parseBoolean() throws NumberFormatException {
        String literal2 = this.getLiteral();
        if (literal2.equals("0")) {
            return false;
        }
        if (literal2.equals("1")) {
            return true;
        }
        if (literal2.equals("true")) {
            return true;
        }
        if (literal2.equals("false")) {
            return false;
        }
        return Boolean.parseBoolean(literal2);
    }

    @Override
    public boolean isDouble() {
        return this.datatype.equals(OWLLiteralImplNoCompression.getOWLDataFactory().getDoubleOWLDatatype());
    }

    @Override
    public double parseDouble() throws NumberFormatException {
        return Double.parseDouble(this.getLiteral());
    }

    @Override
    public boolean isFloat() {
        return this.datatype.equals(OWLLiteralImplNoCompression.getOWLDataFactory().getFloatOWLDatatype());
    }

    @Override
    public float parseFloat() throws NumberFormatException {
        return Float.parseFloat(this.getLiteral());
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public boolean hasLang(String l) {
        if (l == null && this.lang == null) {
            return true;
        }
        if (l == null) {
            l = "";
        }
        return this.lang != null && this.lang.equalsIgnoreCase(l.trim());
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int hashCode = 277;
        hashCode = hashCode * 37 + this.getDatatype().hashCode();
        hashCode *= 37;
        hashCode += Arrays.hashCode(this.literal);
        if (this.hasLang()) {
            hashCode = hashCode * 37 + this.getLang().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLLiteral)) {
                return false;
            }
            OWLLiteral other = (OWLLiteral)obj;
            if (other instanceof OWLLiteralImplNoCompression) {
                return Arrays.equals(this.literal, ((OWLLiteralImplNoCompression)other).literal) && this.datatype.equals(other.getDatatype()) && this.lang.equals(other.getLang());
            }
            return this.getLiteral().equals(other.getLiteral()) && this.datatype.equals(other.getDatatype()) && this.lang.equals(other.getLang());
        }
        return false;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.datatype.compareTo(other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.lang.compareTo(other.getLang());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }
}

