/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLLiteralImpl
extends OWLObjectImpl
implements OWLLiteral {
    private static Logger logger = Logger.getLogger(OWLLiteralImpl.class.getName());
    private static boolean DO_COMPRESSION = true;
    private static final int LOG_COUNTER_SIZE = 100;
    private static int uncompressedSize = 0;
    private static int compressedSize = 0;
    private static int logCounter;
    private final LiteralWrapper literal;
    private final OWLDatatype datatype;
    private final String lang;
    private final int hashcode;
    private static final long serialVersionUID = 5569750232151559959L;

    private static void monitorCompressionEffectiveness(String s, byte[] bytes) {
        uncompressedSize += 2 * s.length();
        compressedSize += bytes.length;
        if (logger.isLoggable(Level.FINE) && logCounter++ >= 100) {
            logCounter = 0;
            logger.fine(uncompressedSize + " bytes compressed down to " + compressedSize);
            if (uncompressedSize != 0) {
                logger.fine("Ratio of compressed to uncompressed = " + (float)(100.0 * (double)compressedSize / (double)uncompressedSize) + "%.");
            }
        }
    }

    public static void setCompressionEnabled(boolean doCompression) {
        DO_COMPRESSION = doCompression;
    }

    public OWLLiteralImpl(OWLDataFactory dataFactory, String literal, String lang, OWLDatatype datatype) {
        super(dataFactory);
        this.literal = new LiteralWrapper(literal);
        if (lang == null || lang.length() == 0) {
            this.lang = "";
            this.datatype = datatype;
        } else {
            OWLDatatype rdfPlainLiteral = dataFactory.getRDFPlainLiteral();
            if (datatype != null && !rdfPlainLiteral.equals(datatype)) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.lang = lang;
            this.datatype = rdfPlainLiteral;
        }
        this.hashcode = this.getHashCode();
    }

    @Override
    public String getLiteral() {
        return this.literal.get();
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.datatype.equals(OWLLiteralImpl.getOWLDataFactory().getRDFPlainLiteral());
    }

    @Override
    public boolean hasLang() {
        return !this.lang.equals("");
    }

    @Override
    public boolean isInteger() {
        return this.datatype.equals(OWLLiteralImpl.getOWLDataFactory().getIntegerOWLDatatype());
    }

    @Override
    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.literal.get());
    }

    @Override
    public boolean isBoolean() {
        return this.datatype.equals(OWLLiteralImpl.getOWLDataFactory().getBooleanOWLDatatype());
    }

    @Override
    public boolean parseBoolean() throws NumberFormatException {
        if (this.literal.get().equals("0")) {
            return false;
        }
        if (this.literal.get().equals("1")) {
            return true;
        }
        if (this.literal.get().equals("true")) {
            return true;
        }
        if (this.literal.get().equals("false")) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isDouble() {
        return this.datatype.equals(OWLLiteralImpl.getOWLDataFactory().getDoubleOWLDatatype());
    }

    @Override
    public double parseDouble() throws NumberFormatException {
        return Double.parseDouble(this.literal.get());
    }

    @Override
    public boolean isFloat() {
        return this.datatype.equals(OWLLiteralImpl.getOWLDataFactory().getFloatOWLDatatype());
    }

    @Override
    public float parseFloat() throws NumberFormatException {
        return Float.parseFloat(this.literal.get());
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public boolean hasLang(String l) {
        if (l == null && this.lang == null) {
            return true;
        }
        if (l == null) {
            l = "";
        }
        return this.lang != null && this.lang.equalsIgnoreCase(l.trim());
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int hashCode = 277;
        hashCode = hashCode * 37 + this.getDatatype().hashCode();
        hashCode *= 37;
        hashCode = this.literal.l != null ? (hashCode += this.literal.l.hashCode()) : (hashCode += Arrays.hashCode(this.literal.bytes));
        if (this.hasLang()) {
            hashCode = hashCode * 37 + this.getLang().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLLiteral)) {
                return false;
            }
            OWLLiteral other = (OWLLiteral)obj;
            return this.literal.get().equals(other.getLiteral()) && this.datatype.equals(other.getDatatype()) && this.lang.equals(other.getLang());
        }
        return false;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.literal.get().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.datatype.compareTo(other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.lang.compareTo(other.getLang());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    private static final class LiteralWrapper {
        private static final String ENCODING = "UTF-8";
        private String l;
        private byte[] bytes;

        public LiteralWrapper(String s) {
            try {
                if (DO_COMPRESSION) {
                    this.l = null;
                    this.bytes = s.getBytes(ENCODING);
                    OWLLiteralImpl.monitorCompressionEffectiveness(s, this.bytes);
                } else {
                    this.l = s;
                    this.bytes = null;
                }
            }
            catch (UnsupportedEncodingException e) {
                this.l = s;
                this.bytes = null;
            }
        }

        public String get() {
            if (this.l == null) {
                try {
                    return new String(this.bytes, ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    throw new OWLRuntimeException(e);
                }
            }
            return this.l;
        }
    }
}

