/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDatatypeDefinitionAxiomImpl
extends OWLAxiomImpl
implements OWLDatatypeDefinitionAxiom {
    private static final long serialVersionUID = 4854618069358602510L;
    private final OWLDatatype datatype;
    private final OWLDataRange dataRange;

    public OWLDatatypeDefinitionAxiomImpl(OWLDataFactory dataFactory, OWLDatatype datatype, OWLDataRange dataRange, Collection<? extends OWLAnnotation> annotations) {
        super(dataFactory, annotations);
        this.datatype = datatype;
        this.dataRange = dataRange;
    }

    @Override
    public OWLAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return OWLDatatypeDefinitionAxiomImpl.getOWLDataFactory().getOWLDatatypeDefinitionAxiom(this.getDatatype(), this.getDataRange());
    }

    @Override
    public OWLDatatypeDefinitionAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return OWLDatatypeDefinitionAxiomImpl.getOWLDataFactory().getOWLDatatypeDefinitionAxiom(this.getDatatype(), this.getDataRange(), this.mergeAnnos(annotations));
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public OWLDataRange getDataRange() {
        return this.dataRange;
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isLogicalAxiom() {
        return true;
    }

    @Override
    public boolean isAnnotationAxiom() {
        return false;
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.DATATYPE_DEFINITION;
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLDatatypeDefinitionAxiom other = (OWLDatatypeDefinitionAxiom)object;
        int diff = this.getDatatype().compareTo(other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.getDataRange().compareTo(other.getDataRange());
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLDatatypeDefinitionAxiom)) {
                return false;
            }
            OWLDatatypeDefinitionAxiom other = (OWLDatatypeDefinitionAxiom)obj;
            return this.datatype.equals(other.getDatatype()) && this.dataRange.equals(other.getDataRange());
        }
        return false;
    }
}

