/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Locale;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplDouble;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplFloat;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplInteger;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplNoCompression;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class InternalsNoCache
implements OWLDataFactoryInternals {
    private final OWLDataFactory factory;
    private final boolean useCompression;

    public InternalsNoCache(OWLDataFactory f, boolean b) {
        this.factory = f;
        this.useCompression = b;
    }

    public void purge() {
    }

    public OWLClass getOWLClass(IRI iri) {
        return new OWLClassImpl(this.factory, iri);
    }

    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return new OWLObjectPropertyImpl(this.factory, iri);
    }

    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return new OWLDataPropertyImpl(this.factory, iri);
    }

    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return new OWLNamedIndividualImpl(this.factory, iri);
    }

    public OWLDatatype getOWLDatatype(IRI iri) {
        return new OWLDatatypeImpl(this.factory, iri);
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return new OWLAnnotationPropertyImpl(this.factory, iri);
    }

    public OWLLiteral getOWLLiteral(float value) {
        return new OWLLiteralImplFloat(this.factory, value, this.getFloatOWLDatatype());
    }

    public OWLLiteral getOWLLiteral(String value) {
        if (this.useCompression) {
            return new OWLLiteralImpl(this.factory, value, "", this.getOWLDatatype(XSDVocabulary.STRING.getIRI()));
        }
        return new OWLLiteralImplNoCompression(this.factory, value, "", this.getOWLDatatype(XSDVocabulary.STRING.getIRI()));
    }

    public OWLLiteral getOWLLiteral(String literal, String lang) {
        String normalisedLang = lang == null ? "" : lang.trim().toLowerCase(Locale.ENGLISH);
        if (this.useCompression) {
            return new OWLLiteralImpl(this.factory, literal, normalisedLang, null);
        }
        return new OWLLiteralImplNoCompression(this.factory, literal, normalisedLang, null);
    }

    public OWLLiteral getOWLLiteral(int value) {
        return new OWLLiteralImplInteger(this.factory, value, this.getIntegerOWLDatatype());
    }

    public OWLLiteral getOWLLiteral(double value) {
        return new OWLLiteralImplDouble(this.factory, value, this.getDoubleOWLDatatype());
    }

    public OWLLiteral getOWLLiteral(String lexicalValue, OWLDatatype datatype) {
        OWLObject literal;
        block11: {
            if (datatype.isRDFPlainLiteral()) {
                int sep = lexicalValue.lastIndexOf(64);
                if (sep != -1) {
                    String lex = lexicalValue.substring(0, sep);
                    String lang = lexicalValue.substring(sep + 1);
                    literal = this.useCompression ? new OWLLiteralImpl(this.factory, lex, lang, this.getRDFPlainLiteral()) : new OWLLiteralImplNoCompression(this.factory, lex, lang, this.getRDFPlainLiteral());
                } else {
                    literal = this.useCompression ? new OWLLiteralImpl(this.factory, lexicalValue, "", datatype) : new OWLLiteralImplNoCompression(this.factory, lexicalValue, "", datatype);
                }
            } else {
                try {
                    if (datatype.isBoolean()) {
                        literal = (lexicalValue = lexicalValue.trim()).equals("1") ? this.factory.getOWLLiteral(true) : (lexicalValue.equals("0") ? this.factory.getOWLLiteral(false) : this.factory.getOWLLiteral(Boolean.parseBoolean(lexicalValue)));
                        break block11;
                    }
                    if (datatype.isFloat()) {
                        try {
                            float f = Float.parseFloat(lexicalValue);
                            literal = this.getOWLLiteral(f);
                        }
                        catch (NumberFormatException e) {
                            if (this.useCompression) {
                                literal = new OWLLiteralImpl(this.factory, lexicalValue, "", datatype);
                                break block11;
                            }
                            literal = new OWLLiteralImplNoCompression(this.factory, lexicalValue, "", datatype);
                        }
                        break block11;
                    }
                    literal = datatype.isDouble() ? this.getOWLLiteral(Double.parseDouble(lexicalValue)) : (datatype.isInteger() ? this.getOWLLiteral(Integer.parseInt(lexicalValue)) : (this.useCompression ? new OWLLiteralImpl(this.factory, lexicalValue, "", datatype) : new OWLLiteralImplNoCompression(this.factory, lexicalValue, "", datatype)));
                }
                catch (NumberFormatException e) {
                    literal = this.useCompression ? new OWLLiteralImpl(this.factory, lexicalValue, "", datatype) : new OWLLiteralImplNoCompression(this.factory, lexicalValue, "", datatype);
                }
            }
        }
        return literal;
    }

    public OWLDatatype getTopDatatype() {
        return this.getOWLDatatype(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
    }

    public OWLDatatype getIntegerOWLDatatype() {
        return this.getOWLDatatype(XSDVocabulary.INTEGER.getIRI());
    }

    public OWLDatatype getFloatOWLDatatype() {
        return this.getOWLDatatype(XSDVocabulary.FLOAT.getIRI());
    }

    public OWLDatatype getDoubleOWLDatatype() {
        return this.getOWLDatatype(XSDVocabulary.DOUBLE.getIRI());
    }

    public OWLDatatype getBooleanOWLDatatype() {
        return this.getOWLDatatype(XSDVocabulary.BOOLEAN.getIRI());
    }

    public OWLDatatype getRDFPlainLiteral() {
        return this.getOWLDatatype(OWLRDFVocabulary.RDF_PLAIN_LITERAL.getIRI());
    }
}

