/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import uk.ac.manchester.cs.bhig.util.Tree;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExplanationOrderer
implements ExplanationOrderer {
    private Set<OWLAxiom> currentExplanation = Collections.emptySet();
    private final Map<OWLEntity, Set<OWLAxiom>> lhs2AxiomMap = new HashMap<OWLEntity, Set<OWLAxiom>>();
    private final Map<OWLAxiom, Set<OWLEntity>> entitiesByAxiomRHS = new HashMap<OWLAxiom, Set<OWLEntity>>();
    private final SeedExtractor seedExtractor = new SeedExtractor();
    private final OWLOntologyManager man = OWLManager.createOWLOntologyManager();
    private OWLOntology ont;
    private final Map<OWLObject, Set<OWLAxiom>> mappedAxioms;
    private final Set<OWLAxiom> consumedAxioms;
    private final Set<AxiomType<?>> passTypes;
    private OWLEntity currentSource;
    private OWLEntity currentTarget;

    public DefaultExplanationOrderer() {
        this.man.addIRIMapper(new OWLOntologyIRIMapper(){

            public IRI getDocumentIRI(IRI ontologyIRI) {
                return ontologyIRI;
            }
        });
        this.mappedAxioms = new HashMap<OWLObject, Set<OWLAxiom>>();
        this.passTypes = new HashSet();
        this.passTypes.add(AxiomType.DISJOINT_CLASSES);
        this.consumedAxioms = new HashSet<OWLAxiom>();
    }

    private void reset() {
        this.lhs2AxiomMap.clear();
        this.entitiesByAxiomRHS.clear();
        this.consumedAxioms.clear();
    }

    @Override
    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, Set<OWLAxiom> axioms) {
        this.currentExplanation = new HashSet<OWLAxiom>(axioms);
        this.buildIndices();
        EntailedAxiomTree root = new EntailedAxiomTree(entailment);
        this.currentSource = this.seedExtractor.getSource(entailment);
        this.insertChildren(this.currentSource, root);
        this.currentTarget = this.seedExtractor.getTarget(entailment);
        Set axs = root.getUserObjectClosure();
        final HashSet<OWLLogicalAxiom> targetAxioms = new HashSet<OWLLogicalAxiom>();
        if (this.currentTarget != null) {
            if (this.currentTarget.isOWLClass()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLClass()));
            }
            if (this.currentTarget.isOWLObjectProperty()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLObjectProperty()));
            }
            if (this.currentTarget.isOWLDataProperty()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLDataProperty()));
            }
            if (this.currentTarget.isOWLNamedIndividual()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLNamedIndividual()));
            }
        }
        ArrayList<OWLAxiom> rootAxioms = new ArrayList<OWLAxiom>();
        for (OWLAxiom ax : axioms) {
            if (axs.contains(ax)) continue;
            rootAxioms.add(ax);
        }
        Collections.sort(rootAxioms, new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                if (targetAxioms.contains(o1)) {
                    return 1;
                }
                if (targetAxioms.contains(o2)) {
                    return -1;
                }
                return 0;
            }
        });
        for (OWLAxiom ax : rootAxioms) {
            root.addChild(new ExplanationTree(ax));
        }
        return root;
    }

    private List<OWLEntity> getRHSEntitiesSorted(OWLAxiom ax) {
        Collection<OWLEntity> entities = this.getRHSEntities(ax);
        ArrayList<OWLEntity> sortedEntities = new ArrayList<OWLEntity>(entities);
        Collections.sort(sortedEntities, new Comparator<OWLObject>(){

            @Override
            public int compare(OWLObject o1, OWLObject o2) {
                if (o1 instanceof OWLProperty) {
                    return -1;
                }
                return 1;
            }
        });
        return sortedEntities;
    }

    private void insertChildren(OWLEntity entity, ExplanationTree tree) {
        HashSet currentPath = new HashSet(tree.getUserObjectPathToRoot());
        Set<Object> axioms = Collections.emptySet();
        if (entity != null) {
            if (entity.isOWLClass()) {
                axioms = this.ont.getAxioms(entity.asOWLClass());
            } else if (entity.isOWLObjectProperty()) {
                axioms = this.ont.getAxioms(entity.asOWLObjectProperty());
            } else if (entity.isOWLDataProperty()) {
                axioms = this.ont.getAxioms(entity.asOWLDataProperty());
            } else if (entity.isOWLNamedIndividual()) {
                axioms = this.ont.getAxioms(entity.asOWLNamedIndividual());
            }
            for (OWLAxiom oWLAxiom : axioms) {
                if (this.passTypes.contains(oWLAxiom.getAxiomType())) continue;
                Set<OWLAxiom> mapped = DefaultExplanationOrderer.getIndexedSet(entity, this.mappedAxioms, true);
                if (this.consumedAxioms.contains(oWLAxiom) || mapped.contains(oWLAxiom) || currentPath.contains(oWLAxiom)) continue;
                mapped.add(oWLAxiom);
                this.consumedAxioms.add(oWLAxiom);
                ExplanationTree child = new ExplanationTree(oWLAxiom);
                tree.addChild(child);
                for (OWLEntity ent : this.getRHSEntitiesSorted(oWLAxiom)) {
                    this.insertChildren(ent, child);
                }
            }
        }
        this.sortChildrenAxioms(tree);
    }

    private void sortChildrenAxioms(ExplanationTree tree) {
        OWLAxiomTreeComparator comparator = new OWLAxiomTreeComparator();
        tree.sortChildren(comparator);
    }

    private void buildIndices() {
        this.reset();
        AxiomMapBuilder builder = new AxiomMapBuilder();
        for (OWLAxiom ax : this.currentExplanation) {
            ax.accept(builder);
        }
        try {
            if (this.ont != null) {
                this.man.removeOntology(this.ont);
            }
            this.ont = this.man.createOntology(IRI.create("http://www.semanticweb.org/ontology" + System.currentTimeMillis()));
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            for (OWLAxiom ax : this.currentExplanation) {
                changes.add(new AddAxiom(this.ont, ax));
                ax.accept(builder);
            }
            this.man.applyChanges(changes);
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private static <K, E> Set<E> getIndexedSet(K obj, Map<K, Set<E>> map, boolean addIfEmpty) {
        Set<E> values = map.get(obj);
        if (values == null) {
            values = new HashSet();
            if (addIfEmpty) {
                map.put(obj, values);
            }
        }
        return values;
    }

    protected Set<OWLAxiom> getAxiomsForLHS(OWLEntity lhs) {
        return DefaultExplanationOrderer.getIndexedSet(lhs, this.lhs2AxiomMap, true);
    }

    private Collection<OWLEntity> getRHSEntities(OWLAxiom axiom) {
        return DefaultExplanationOrderer.getIndexedSet(axiom, this.entitiesByAxiomRHS, true);
    }

    protected void indexAxiomsByRHSEntities(OWLObject rhs, OWLAxiom axiom) {
        DefaultExplanationOrderer.getIndexedSet(axiom, this.entitiesByAxiomRHS, true).addAll(rhs.getSignature());
    }

    private class AxiomMapBuilder
    implements OWLAxiomVisitor {
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(axiom.getSubClass().asOWLClass()).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getSuperClass(), axiom);
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (!desc.isAnonymous()) {
                    DefaultExplanationOrderer.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(desc, axiom);
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getDomain(), axiom);
        }

        public void visit(OWLImportsDeclaration axiom) {
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getDomain(), axiom);
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    DefaultExplanationOrderer.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                DefaultExplanationOrderer.this.getAxiomsForLHS(ind.asOWLNamedIndividual()).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(ind, axiom);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    DefaultExplanationOrderer.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            DefaultExplanationOrderer.this.getAxiomsForLHS(axiom.getOWLClass()).add(axiom);
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getIndividual().isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(axiom.getIndividual().asOWLNamedIndividual()).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getClassExpression(), axiom);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (!desc.isAnonymous()) {
                    DefaultExplanationOrderer.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(desc, axiom);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getSubject(), axiom);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty()).add(axiom);
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                DefaultExplanationOrderer.this.getAxiomsForLHS(ind.asOWLNamedIndividual()).add(axiom);
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(ind, axiom);
            }
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            if (!axiom.getFirstProperty().isAnonymous()) {
                DefaultExplanationOrderer.this.getAxiomsForLHS(axiom.getFirstProperty().asOWLObjectProperty()).add(axiom);
            }
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getFirstProperty(), axiom);
            DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getSecondProperty(), axiom);
        }

        public void visit(SWRLRule rule) {
        }

        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                DefaultExplanationOrderer.this.indexAxiomsByRHSEntities(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }
    }

    private static class SeedExtractor
    implements OWLAxiomVisitor {
        private OWLEntity source;
        private OWLEntity target;

        public OWLEntity getSource(OWLAxiom axiom) {
            axiom.accept(this);
            return this.source;
        }

        public OWLEntity getTarget(OWLAxiom axiom) {
            axiom.accept(this);
            return this.target;
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            OWLClassExpression classExpression;
            if (!axiom.getSubClass().isAnonymous()) {
                this.source = axiom.getSubClass().asOWLClass();
            }
            if (!axiom.getSuperClass().isOWLNothing() && !(classExpression = axiom.getSuperClass()).isAnonymous()) {
                this.target = classExpression.asOWLClass();
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (ce.isAnonymous()) continue;
                if (this.source == null) {
                    this.source = ce.asOWLClass();
                    continue;
                }
                if (this.target != null) break;
                this.target = ce.asOWLClass();
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
        }

        public void visit(OWLImportsDeclaration axiom) {
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                this.source = ((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty();
            }
            if (!((OWLObjectPropertyExpression)axiom.getSuperProperty()).isAnonymous()) {
                this.target = ((OWLObjectPropertyExpression)axiom.getSuperProperty()).asOWLObjectProperty();
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                this.source = axiom.getIndividual().asOWLNamedIndividual();
                this.target = axiom.getClassExpression().asOWLClass();
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClass cls : axiom.getNamedClasses()) {
                if (this.source == null) {
                    this.source = cls;
                    continue;
                }
                if (this.target != null) break;
                this.target = cls;
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSameIndividualAxiom axiom) {
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        }

        public void visit(SWRLRule rule) {
        }

        public void visit(OWLHasKeyAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OWLAxiomTreeComparator
    implements Comparator<Tree<OWLAxiom>>,
    Serializable {
        private static final long serialVersionUID = -964659673213179294L;

        @Override
        public int compare(Tree<OWLAxiom> o1, Tree<OWLAxiom> o2) {
            OWLAxiom ax1 = o1.getUserObject();
            OWLAxiom ax2 = o2.getUserObject();
            if (ax1 instanceof OWLEquivalentClassesAxiom) {
                return 1;
            }
            if (ax2 instanceof OWLEquivalentClassesAxiom) {
                return -1;
            }
            if (ax1 instanceof OWLPropertyAxiom) {
                return -1;
            }
            int childCount1 = o1.getChildCount();
            childCount1 = childCount1 > 0 ? 0 : 1;
            int childCount2 = o2.getChildCount();
            int diff = childCount1 - (childCount2 = childCount2 > 0 ? 0 : 1);
            if (diff != 0) {
                return diff;
            }
            if (ax1 instanceof OWLSubClassOfAxiom && ax2 instanceof OWLSubClassOfAxiom) {
                OWLSubClassOfAxiom sc1 = (OWLSubClassOfAxiom)ax1;
                OWLSubClassOfAxiom sc2 = (OWLSubClassOfAxiom)ax2;
                return sc1.getSuperClass().compareTo(sc2.getSuperClass());
            }
            return 1;
        }
    }
}

