/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.ShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNameShortFormProvider
implements ShortFormProvider {
    private final NamespaceUtil namespaceUtil = new NamespaceUtil();

    public QNameShortFormProvider() {
        this(new HashMap<String, String>());
    }

    public QNameShortFormProvider(Map<String, String> prefix2NamespaceMap) {
        for (Map.Entry<String, String> e : prefix2NamespaceMap.entrySet()) {
            this.namespaceUtil.setPrefix(e.getKey(), e.getValue());
        }
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        String[] result = new String[2];
        String uriString = entity.getIRI().toString();
        this.namespaceUtil.split(uriString, result);
        String namespace = result[0];
        String localName = result[1];
        String prefix = this.namespaceUtil.getPrefix(namespace);
        return prefix + ":" + localName;
    }

    @Override
    public void dispose() {
    }
}

