/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitor;

public class ObjectPropertySimplifier {
    private final OWLDataFactory dataFactory;
    private final Simplifier simplifier;

    public ObjectPropertySimplifier(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
        this.simplifier = new Simplifier();
    }

    public OWLObjectPropertyExpression getSimplified(OWLObjectPropertyExpression prop) {
        this.simplifier.reset();
        prop.accept(this.simplifier);
        if (this.simplifier.isInverse()) {
            return this.dataFactory.getOWLObjectInverseOf(this.simplifier.getProperty());
        }
        return this.simplifier.getProperty();
    }

    private static class Simplifier
    implements OWLPropertyExpressionVisitor {
        private OWLObjectProperty property;
        private int depth;

        public void reset() {
            this.depth = 0;
            this.property = null;
        }

        public OWLObjectProperty getProperty() {
            return this.property;
        }

        public boolean isInverse() {
            return this.depth % 2 != 0;
        }

        public void visit(OWLObjectProperty p) {
            this.property = p;
        }

        public void visit(OWLObjectInverseOf p) {
            ++this.depth;
            p.getInverse().accept(this);
        }

        public void visit(OWLDataProperty p) {
        }
    }
}

