/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;
import org.semanticweb.owlapi.util.OWLObjectWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassLiteralCollector
extends OWLObjectWalker<OWLObject> {
    private final Set<OWLClass> pos = new HashSet<OWLClass>();
    private final Set<OWLClass> neg = new HashSet<OWLClass>();
    private boolean processed = false;

    public OWLClassLiteralCollector(Set<OWLObject> objects) {
        super(objects);
    }

    public OWLClassLiteralCollector(Set<OWLObject> objects, boolean visitDuplicates) {
        super(objects, visitDuplicates);
    }

    private void process() {
        if (!this.processed) {
            this.processed = true;
            this.walkStructure(new OWLClassLiteralCollectorVisitor());
        }
    }

    public Set<OWLClass> getPositiveLiterals() {
        this.process();
        return new HashSet<OWLClass>(this.pos);
    }

    public Set<OWLClass> getNegativeLiterals() {
        this.process();
        return new HashSet<OWLClass>(this.neg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWLClassLiteralCollectorVisitor
    extends OWLObjectVisitorExAdapter<Object> {
        @Override
        public Object visit(OWLClass desc) {
            List<OWLClassExpression> path = OWLClassLiteralCollector.this.getClassExpressionPath();
            if (path.size() > 1) {
                OWLClassExpression prev = path.get(path.size() - 2);
                if (prev instanceof OWLObjectComplementOf) {
                    OWLClassLiteralCollector.this.neg.add(desc);
                } else {
                    OWLClassLiteralCollector.this.pos.add(desc);
                }
            } else {
                OWLClassLiteralCollector.this.pos.add(desc);
            }
            return null;
        }
    }
}

