/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.WeakCache;
import org.semanticweb.owlapi.util.WeakIndexCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Namespacer
implements Serializable {
    private Pattern qnamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9\\.\\-_\\%]*");
    private transient WeakIndexCache<IRI, String> prefixedNamesCache = new WeakIndexCache();
    private transient WeakCache<IRI> unprefixable = new WeakCache();
    private Map<String, String> prefix2NamespaceMap = new HashMap<String, String>();

    public Namespacer(Map<String, String> prefMap) {
        this.prefix2NamespaceMap.putAll(prefMap);
    }

    public void resetCaches() {
        this.unprefixable.clear();
        this.prefixedNamesCache.clear();
        this.prefix2NamespaceMap.clear();
    }

    public void addPrefixMap(Map<String, String> prefixes) {
        this.prefix2NamespaceMap.putAll(prefixes);
    }

    public void addPrefix(String namespace, String value) {
        this.prefix2NamespaceMap.put(namespace, value);
        this.unprefixable.clear();
        this.prefixedNamesCache.clear();
    }

    public String getQName(IRI iri) {
        String cached = this.prefixedNamesCache.get(iri);
        if (cached != null) {
            return cached;
        }
        String iriString = iri.toString();
        String toReturn = this.getQName(iriString);
        if (toReturn == null) {
            this.unprefixable.cache(iri);
        } else {
            this.prefixedNamesCache.cache(iri, toReturn);
        }
        return toReturn;
    }

    public String getQName(String s) {
        for (String prefixName : this.prefix2NamespaceMap.keySet()) {
            String localName;
            Matcher matcher;
            String prefix = this.prefix2NamespaceMap.get(prefixName);
            if (!s.startsWith(prefix) || !(matcher = this.qnamePattern.matcher(localName = s.substring(prefix.length()))).find() || !localName.equals(matcher.group())) continue;
            String toReturn = null;
            toReturn = prefixName.endsWith(":") ? prefixName + localName : prefixName + ":" + localName;
            return toReturn;
        }
        return null;
    }
}

