/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.vocab.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceUtil {
    private final Map<String, String> namespace2PrefixMap;
    private final Map<String, String> standardNamespacePrefixMappings = new HashMap<String, String>();
    private int candidateIndex = 1;

    public NamespaceUtil() {
        this.standardNamespacePrefixMappings.put("http://purl.org/dc/elements/1.1/", "dc");
        this.standardNamespacePrefixMappings.put(Namespaces.SKOS.toString(), "skos");
        this.namespace2PrefixMap = new HashMap<String, String>();
        this.namespace2PrefixMap.put(Namespaces.OWL.toString(), "owl");
        this.namespace2PrefixMap.put(Namespaces.RDFS.toString(), "rdfs");
        this.namespace2PrefixMap.put(Namespaces.RDF.toString(), "rdf");
        this.namespace2PrefixMap.put(Namespaces.XSD.toString(), "xsd");
    }

    public static boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    public static boolean isDigit(char ch) {
        return Character.isDigit(ch);
    }

    @Deprecated
    public static boolean isNCNameChar(char ch) {
        return NamespaceUtil.isLetter(ch) || NamespaceUtil.isDigit(ch) || ch == '.' || ch == '-' || ch == '_';
    }

    @Deprecated
    public static boolean isNCNameStartChar(char ch) {
        return NamespaceUtil.isLetter(ch) || ch == '_';
    }

    public String[] split(String s, String[] result) {
        String temp = s;
        temp = temp.replaceAll("\\%[0-9a-fA-F][0-9a-fA-F]", "---");
        int startIndex = s.length() - 1;
        for (int index = s.length() - 1; index > -1; --index) {
            char curChar = temp.charAt(index);
            if (XMLUtils.isNCNameStartChar(curChar)) {
                startIndex = index;
                continue;
            }
            if (!XMLUtils.isNCNameChar(curChar)) break;
        }
        String[] split = result != null ? result : new String[2];
        if (!XMLUtils.isNCNameStartChar(s.charAt(startIndex))) {
            split[0] = "";
            split[1] = "";
        } else {
            split[0] = s.substring(0, startIndex);
            split[1] = s.substring(startIndex, s.length());
        }
        return split;
    }

    public String getPrefix(String namespace) {
        String prefix = this.namespace2PrefixMap.get(namespace);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.generatePrefix(namespace);
        if (prefix == null) {
            while (this.namespace2PrefixMap.containsValue(prefix = "p" + this.candidateIndex++)) {
            }
        }
        this.namespace2PrefixMap.put(namespace, prefix);
        return prefix;
    }

    public Map<String, String> getNamespace2PrefixMap() {
        return Collections.unmodifiableMap(this.namespace2PrefixMap);
    }

    public String generatePrefix(String namespace) {
        String computedPrefix;
        char curChar;
        String prefix = this.standardNamespacePrefixMappings.get(namespace);
        if (prefix != null) {
            this.namespace2PrefixMap.put(namespace, prefix);
            return prefix;
        }
        int startIndex = -1;
        for (int i = namespace.length() - 1; i > -1; --i) {
            char curChar2 = namespace.charAt(i);
            boolean isStartChar = XMLUtils.isNCNameStartChar(curChar2);
            if (isStartChar || startIndex == -1) {
                if (!isStartChar) continue;
                startIndex = i;
                continue;
            }
            if (!XMLUtils.isNCNameChar(curChar2)) break;
        }
        if (startIndex == -1) {
            return null;
        }
        int endIndex = startIndex + 1;
        for (int i = startIndex; endIndex < namespace.length() && i < namespace.length() && XMLUtils.isNCNameChar(curChar = namespace.charAt(endIndex)) && curChar != '.'; ++i) {
            endIndex = i + 1;
        }
        String candidatePrefix = computedPrefix = namespace.substring(startIndex, endIndex);
        int index = 2;
        while (this.namespace2PrefixMap.containsValue(candidatePrefix) || this.standardNamespacePrefixMappings.containsValue(candidatePrefix)) {
            candidatePrefix = computedPrefix + index;
            ++index;
        }
        return candidatePrefix;
    }

    public void setPrefix(String namespace, String prefix) {
        this.namespace2PrefixMap.put(namespace, prefix);
    }
}

