/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMap<Key, Value>
implements Serializable {
    private static final long serialVersionUID = 8939237917649727834L;
    private final Map<Key, Collection<Value>> map;
    private int size = 0;
    private boolean useSets = true;
    private boolean threadSafe = false;

    public MultiMap() {
        this(false);
    }

    public MultiMap(boolean threadsafe) {
        this.threadSafe = threadsafe;
        this.map = this.threadSafe ? CollectionFactory.createSyncMap() : CollectionFactory.createMap();
    }

    public MultiMap(boolean threadsafe, boolean usesets) {
        this(threadsafe);
        this.useSets = usesets;
    }

    public boolean put(Key key, Value value) {
        boolean toReturn;
        Collection<Value> set = this.map.get(key);
        if (set == null) {
            set = this.createCollection();
            this.map.put(key, set);
        }
        if (toReturn = set.add(value)) {
            this.size = -1;
        }
        return toReturn;
    }

    private Collection<Value> createCollection() {
        Collection<Object> toReturn = this.useSets ? (this.threadSafe ? CollectionFactory.createSyncSet() : CollectionFactory.createSet()) : (this.threadSafe ? Collections.synchronizedList(new ArrayList()) : new ArrayList());
        return toReturn;
    }

    public void setEntry(Key key, Collection<Value> values) {
        this.map.put(key, values);
        this.size = -1;
    }

    public Collection<Value> get(Key key) {
        Collection<Value> collection = this.map.get(key);
        if (collection != null) {
            return collection;
        }
        return Collections.emptyList();
    }

    public Set<Key> keySet() {
        return this.map.keySet();
    }

    public Set<Value> getAllValues() {
        Set toReturn = CollectionFactory.createSet();
        for (Collection<Value> s : this.map.values()) {
            toReturn.addAll(s);
        }
        return toReturn;
    }

    public boolean remove(Key key) {
        if (this.map.remove(key) != null) {
            this.size = -1;
            return true;
        }
        return false;
    }

    public boolean remove(Key key, Value value) {
        Collection<Value> c = this.map.get(key);
        if (c != null) {
            boolean toReturn = c.remove(value);
            if (!toReturn) {
                return false;
            }
            this.size = -1;
            if (c.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    public int size() {
        if (this.size < 0) {
            this.size = this.getAllValues().size();
        }
        return this.size;
    }

    public boolean contains(Key k, Value v) {
        Collection<Value> collection = this.map.get(k);
        if (collection == null) {
            return false;
        }
        return collection.contains(v);
    }

    public boolean containsKey(Key k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(Value v) {
        for (Collection<Value> c : this.map.values()) {
            if (!c.contains(v)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    public String toString() {
        return "MultiMap " + this.size() + "\n" + this.map.toString().replace(",", "\n");
    }

    public void putAll(MultiMap<Key, Value> otherMap) {
        for (Key k : otherMap.keySet()) {
            this.putAll(k, otherMap.get(k));
        }
    }

    public void putAll(Key k, Collection<Value> v) {
        Collection<Value> set = this.map.get(k);
        if (set == null) {
            set = this.createCollection();
            this.setEntry(k, set);
        }
        set.addAll(v);
        this.size = -1;
    }

    public boolean isValueSetsEqual() {
        if (this.map.size() < 2) {
            return true;
        }
        ArrayList<Collection<Value>> list = new ArrayList<Collection<Value>>(this.map.values());
        for (int i = 1; i < list.size(); ++i) {
            if (((Object)((Collection)list.get(0))).equals(list.get(i))) continue;
            return false;
        }
        return true;
    }
}

