/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import org.semanticweb.owlapi.model.IRI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OWLOntologyID
implements Comparable<OWLOntologyID>,
Serializable {
    private static final long serialVersionUID = -1776512899375657560L;
    private static int counter = 0;
    private static final String ANON_PREFIX = "Anonymous-";
    private String internalID;
    private final IRI ontologyIRI;
    private final IRI versionIRI;
    private int hashCode;

    public OWLOntologyID(IRI ontologyIRI) {
        this(ontologyIRI, null);
    }

    public OWLOntologyID(IRI ontologyIRI, IRI versionIRI) {
        this.ontologyIRI = ontologyIRI;
        this.hashCode = 17;
        if (ontologyIRI != null) {
            this.internalID = null;
            this.hashCode += 37 * ontologyIRI.hashCode();
        }
        if (versionIRI != null) {
            if (ontologyIRI == null) {
                throw new IllegalArgumentException("If the ontology IRI is null then it is not possible to specify a version IRI");
            }
            this.versionIRI = versionIRI;
            this.hashCode += 37 * versionIRI.hashCode();
        } else {
            this.versionIRI = null;
        }
        if (ontologyIRI == null) {
            this.internalID = ANON_PREFIX + OWLOntologyID.getNextCounter();
            this.hashCode += 37 * this.internalID.hashCode();
        }
    }

    public OWLOntologyID() {
        this(null, null);
    }

    public boolean isOWL2DLOntologyID() {
        return this.ontologyIRI == null || !this.ontologyIRI.isReservedVocabulary() && (this.versionIRI == null || !this.versionIRI.isReservedVocabulary());
    }

    @Override
    public int compareTo(OWLOntologyID o) {
        return this.toString().compareTo(o.toString());
    }

    public IRI getOntologyIRI() {
        return this.ontologyIRI;
    }

    public IRI getVersionIRI() {
        return this.versionIRI;
    }

    public IRI getDefaultDocumentIRI() {
        if (this.ontologyIRI != null) {
            if (this.versionIRI != null) {
                return this.versionIRI;
            }
            return this.ontologyIRI;
        }
        return null;
    }

    public boolean isAnonymous() {
        return this.ontologyIRI == null;
    }

    private static int getNextCounter() {
        return ++counter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ontologyIRI != null) {
            sb.append(this.ontologyIRI.toQuotedString());
            if (this.versionIRI != null) {
                sb.append(this.versionIRI.toQuotedString());
            }
        } else {
            sb.append(this.internalID);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntologyID)) {
            return false;
        }
        OWLOntologyID other = (OWLOntologyID)obj;
        if (this.ontologyIRI != null) {
            if (other.ontologyIRI == null) {
                return false;
            }
            if (!this.ontologyIRI.equals(other.ontologyIRI)) {
                return false;
            }
            if (this.versionIRI != null) {
                if (other.versionIRI == null) {
                    return false;
                }
                return this.versionIRI.equals(other.versionIRI);
            }
            return other.versionIRI == null;
        }
        if (other.ontologyIRI != null) {
            return false;
        }
        return this.internalID.equals(other.internalID);
    }
}

