/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

public class XMLUtils {
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String QUOT = "&quot;";
    public static final String AMP = "&amp;";
    public static final String APOS = "&apos;";

    public static boolean isXMLNameStartCharacter(int codePoint) {
        return codePoint == 58 || codePoint >= 65 && codePoint <= 90 || codePoint == 95 || codePoint >= 97 && codePoint <= 122 || codePoint >= 192 && codePoint <= 214 || codePoint >= 216 && codePoint <= 246 || codePoint >= 248 && codePoint <= 767 || codePoint >= 880 && codePoint <= 893 || codePoint >= 895 && codePoint <= 8191 || codePoint >= 8204 && codePoint <= 8205 || codePoint >= 8304 && codePoint <= 8591 || codePoint >= 11264 && codePoint <= 12271 || codePoint >= 12289 && codePoint <= 55295 || codePoint >= 63744 && codePoint <= 64975 || codePoint >= 65008 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 983039;
    }

    public static boolean isXMLNameChar(int codePoint) {
        return XMLUtils.isXMLNameStartCharacter(codePoint) || codePoint == 45 || codePoint == 46 || codePoint >= 48 && codePoint <= 57 || codePoint == 183 || codePoint >= 768 && codePoint <= 879 || codePoint >= 8255 && codePoint <= 8256;
    }

    public static boolean isNCNameStartChar(int codePoint) {
        return codePoint != 58 && XMLUtils.isXMLNameStartCharacter(codePoint);
    }

    public static boolean isNCNameChar(int codePoint) {
        return codePoint != 58 && XMLUtils.isXMLNameChar(codePoint);
    }

    public static boolean isNCName(CharSequence s) {
        int codePoint;
        if (XMLUtils.isNullOrEmpty(s)) {
            return false;
        }
        int firstCodePoint = Character.codePointAt(s, 0);
        if (!XMLUtils.isNCNameStartChar(firstCodePoint)) {
            return false;
        }
        for (int i = Character.charCount(firstCodePoint); i < s.length(); i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(s, i);
            if (XMLUtils.isNCNameChar(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static boolean isQName(CharSequence s) {
        int codePoint;
        if (XMLUtils.isNullOrEmpty(s)) {
            return false;
        }
        boolean foundColon = false;
        boolean inNCName = false;
        for (int i = 0; i < s.length(); i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(s, i);
            if (codePoint == 58) {
                if (foundColon) {
                    return false;
                }
                foundColon = true;
                if (!inNCName) {
                    return false;
                }
                inNCName = false;
                continue;
            }
            if (!inNCName) {
                if (!XMLUtils.isXMLNameStartCharacter(codePoint)) {
                    return false;
                }
                inNCName = true;
                continue;
            }
            if (XMLUtils.isXMLNameChar(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNCNameSuffix(CharSequence s) {
        return XMLUtils.getNCNameSuffixIndex(s) != -1;
    }

    public static int getNCNameSuffixIndex(CharSequence s) {
        int index = -1;
        for (int i = s.length() - 1; i > -1; --i) {
            if (Character.isLowSurrogate(s.charAt(i))) continue;
            int codePoint = Character.codePointAt(s, i);
            if (XMLUtils.isNCNameStartChar(codePoint)) {
                index = i;
            }
            if (!XMLUtils.isNCNameChar(codePoint)) break;
        }
        return index;
    }

    public static String getNCNameSuffix(CharSequence s) {
        int localPartStartIndex = XMLUtils.getNCNameSuffixIndex(s);
        if (localPartStartIndex != -1) {
            return ((Object)s).toString().substring(localPartStartIndex);
        }
        return null;
    }

    public static String escapeXML(CharSequence s) {
        int codePoint;
        StringBuilder sb = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(s, i);
            if (codePoint == 60) {
                sb.append(LT);
                continue;
            }
            if (codePoint == 62) {
                sb.append(GT);
                continue;
            }
            if (codePoint == 34) {
                sb.append(QUOT);
                continue;
            }
            if (codePoint == 38) {
                sb.append(AMP);
                continue;
            }
            if (codePoint == 39) {
                sb.append(APOS);
                continue;
            }
            sb.appendCodePoint(codePoint);
        }
        return sb.toString();
    }

    private static boolean isNullOrEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }
}

