/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class StreamDocumentSource
implements OWLOntologyDocumentSource {
    private static int counter = 0;
    private final IRI documentIRI;
    private byte[] buffer;

    public StreamDocumentSource(InputStream is) {
        this(is, StreamDocumentSource.getNextDocumentIRI());
    }

    public static synchronized IRI getNextDocumentIRI() {
        return IRI.create("inputstream:ontology" + ++counter);
    }

    public StreamDocumentSource(InputStream stream, IRI documentIRI) {
        this.documentIRI = documentIRI;
        this.readIntoBuffer(stream);
    }

    private void readIntoBuffer(InputStream reader) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length = 100000;
            byte[] tempBuffer = new byte[100000];
            int read = 0;
            do {
                if ((read = reader.read(tempBuffer, 0, 100000)) <= 0) continue;
                bos.write(tempBuffer, 0, read);
            } while (read > 0);
            this.buffer = bos.toByteArray();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public boolean isInputStreamAvailable() {
        return true;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buffer);
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    public Reader getReader() {
        throw new OWLRuntimeException("Reader not available.  Check with StreamDocumentSource.isReaderAvailable() first!");
    }

    public boolean isReaderAvailable() {
        return false;
    }
}

