/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.OWLCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.ImportsStructureEntitySorter;
import org.semanticweb.owlapi.util.ShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortForm2AnnotationGenerator
implements OWLCompositeOntologyChange {
    private final IRI annotationIRI;
    private final String languageTag;
    private final OWLOntologyManager ontologyManager;
    private final ShortFormProvider shortFormProvider;
    private final OWLOntology ontology;

    public ShortForm2AnnotationGenerator(OWLOntologyManager ontologyManager, OWLOntology ontology, ShortFormProvider shortFormProvider, IRI annotationIRI, String languageTag) {
        this.ontologyManager = ontologyManager;
        this.shortFormProvider = shortFormProvider;
        this.annotationIRI = annotationIRI;
        this.languageTag = languageTag;
        this.ontology = ontology;
    }

    public ShortForm2AnnotationGenerator(OWLOntologyManager ontologyManager, OWLOntology ontology, ShortFormProvider shortFormProvider, IRI annotationIRI) {
        this(ontologyManager, ontology, shortFormProvider, annotationIRI, null);
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        ImportsStructureEntitySorter sorter = new ImportsStructureEntitySorter(this.ontology, this.ontologyManager);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        Map ontology2EntityMap = sorter.getObjects();
        for (OWLOntology ont : ontology2EntityMap.keySet()) {
            for (OWLEntity ent : ontology2EntityMap.get(ont)) {
                String shortForm = this.shortFormProvider.getShortForm(ent);
                OWLLiteral con = this.languageTag != null ? this.ontologyManager.getOWLDataFactory().getOWLLiteral(shortForm, this.languageTag) : this.ontologyManager.getOWLDataFactory().getOWLLiteral(shortForm);
                if (!this.ontology.containsEntityInSignature(ent)) continue;
                AddAxiom chg = new AddAxiom(ont, this.ontologyManager.getOWLDataFactory().getOWLAnnotationAssertionAxiom(this.ontologyManager.getOWLDataFactory().getOWLAnnotationProperty(this.annotationIRI), ent.getIRI(), con));
                changes.add(chg);
            }
        }
        return changes;
    }
}

