/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPTypeHandler
extends TriplePredicateHandler {
    private static final Logger logger = Logger.getLogger(TPTypeHandler.class.getName());

    public TPTypeHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDF_TYPE.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        this.getConsumer().addClassExpression(object, false);
        if (this.isAnonymous(object)) {
            return false;
        }
        if (object.isReservedVocabulary()) {
            return object.equals(OWLRDFVocabulary.OWL_THING.getIRI());
        }
        return true;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (OWLRDFVocabulary.BUILT_IN_VOCABULARY_IRIS.contains(object) && !object.equals(OWLRDFVocabulary.OWL_THING.getIRI())) {
            logger.fine("Individual of builtin type " + object);
        }
        this.addAxiom(this.getDataFactory().getOWLClassAssertionAxiom(this.translateClassExpression(object), this.translateIndividual(subject), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }
}

