/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.util.Locale;
import org.coode.owlapi.obo.parser.AbstractTagValueHandler;
import org.coode.owlapi.obo.parser.OBOConsumer;
import org.coode.owlapi.obo.parser.OBOVocabulary;
import org.coode.string.EscapeUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.SetOntologyID;

public class DefaultNamespaceTagValueHandler
extends AbstractTagValueHandler {
    public DefaultNamespaceTagValueHandler(OBOConsumer consumer) {
        super(OBOVocabulary.DEFAULT_NAMESPACE.getName(), consumer);
    }

    public void handle(String id, String value, String comment) {
        String unescaped = EscapeUtils.unescapeString(value);
        String stripped = unescaped.replace(" ", "-");
        if (!stripped.startsWith("http:")) {
            this.getConsumer().setDefaultNamespace(value.toUpperCase(Locale.getDefault()));
            IRI iri = this.getIdIRI(stripped);
            this.applyChange(new SetOntologyID(this.getOntology(), new OWLOntologyID(iri)));
        } else {
            if (stripped.endsWith("/")) {
                stripped = stripped.substring(0, stripped.length() - 1);
            }
            IRI iri = IRI.create(stripped);
            this.applyChange(new SetOntologyID(this.getOntology(), new OWLOntologyID(iri)));
        }
    }
}

