/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.SingleExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SingleExplanationGeneratorImpl;
import com.clarkparsia.owlapi.explanation.util.OntologyUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackBoxExplanation
extends SingleExplanationGeneratorImpl
implements SingleExplanationGenerator {
    private static final Logger log = Logger.getLogger(BlackBoxExplanation.class.getName());
    private OWLOntology debuggingOntology;
    private final Set<OWLAxiom> debuggingAxioms;
    private final Set<OWLEntity> objectsExpandedWithDefiningAxioms;
    private final Set<OWLEntity> objectsExpandedWithReferencingAxioms;
    private final Set<OWLAxiom> expandedWithDefiningAxioms;
    private final Set<OWLAxiom> expandedWithReferencingAxioms;
    private final Map<OWLAxiom, OWLAxiom> expandedAxiomMap;
    public static final int DEFAULT_INITIAL_EXPANSION_LIMIT = 50;
    private int initialExpansionLimit;
    private int expansionLimit;
    private double expansionFactor;
    private static final int DEFAULT_FAST_PRUNING_WINDOW_SIZE = 10;
    private int fastPruningWindowSize;
    private boolean performRepeatedFastPruning;
    private final OWLOntologyManager owlOntologyManager;
    private int satTestCount;
    private int ontologyCounter;

    public BlackBoxExplanation(OWLOntology ontology, OWLReasonerFactory reasonerFactory, OWLReasoner reasoner) {
        super(ontology, reasonerFactory, reasoner);
        this.expansionLimit = this.initialExpansionLimit = 50;
        this.expansionFactor = 1.25;
        this.fastPruningWindowSize = 0;
        this.performRepeatedFastPruning = false;
        this.satTestCount = 0;
        this.ontologyCounter = 0;
        this.owlOntologyManager = OWLManager.createOWLOntologyManager();
        this.debuggingAxioms = new LinkedHashSet<OWLAxiom>();
        this.objectsExpandedWithDefiningAxioms = new HashSet<OWLEntity>();
        this.objectsExpandedWithReferencingAxioms = new HashSet<OWLEntity>();
        this.expandedWithDefiningAxioms = new HashSet<OWLAxiom>();
        this.expandedWithReferencingAxioms = new HashSet<OWLAxiom>();
        this.expandedAxiomMap = new HashMap<OWLAxiom, OWLAxiom>();
    }

    public void dispose() {
        this.reset();
        this.getReasoner().dispose();
    }

    private void reset() {
        if (this.debuggingOntology != null) {
            this.owlOntologyManager.removeOntology(this.debuggingOntology);
            this.debuggingOntology = null;
        }
        this.debuggingAxioms.clear();
        this.objectsExpandedWithDefiningAxioms.clear();
        this.objectsExpandedWithReferencingAxioms.clear();
        this.expandedWithDefiningAxioms.clear();
        this.expandedWithReferencingAxioms.clear();
        this.expandedAxiomMap.clear();
        this.expansionLimit = this.initialExpansionLimit;
    }

    @Override
    public Set<OWLAxiom> getExplanation(OWLClassExpression unsatClass) {
        if (!this.getDefinitionTracker().isDefined(unsatClass)) {
            return Collections.emptySet();
        }
        try {
            ++this.satTestCount;
            if (this.isFirstExplanation() && this.getReasoner().isSatisfiable(unsatClass)) {
                return Collections.emptySet();
            }
            this.reset();
            this.expandUntilUnsatisfiable(unsatClass);
            this.pruneUntilMinimal(unsatClass);
            this.removeDeclarations();
            this.ontologyCounter = 0;
            return new HashSet<OWLAxiom>(this.debuggingAxioms);
        }
        catch (OWLException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private int expandAxioms() {
        int added;
        int axiomsAdded = 0;
        int remainingSpace = this.expansionLimit;
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithDefiningAxioms.contains(ax)) continue;
            for (OWLEntity curObj : ax.getSignature()) {
                if (this.objectsExpandedWithDefiningAxioms.contains(curObj)) continue;
                added = this.expandWithDefiningAxioms(curObj, remainingSpace);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * this.expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithDefiningAxioms.add(curObj);
            }
            this.expandedWithDefiningAxioms.add(ax);
        }
        if (axiomsAdded > 0) {
            return axiomsAdded;
        }
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithReferencingAxioms.contains(ax)) continue;
            for (OWLEntity curObj : ax.getSignature()) {
                if (this.objectsExpandedWithReferencingAxioms.contains(curObj)) continue;
                added = this.expandWithReferencingAxioms(curObj, this.expansionLimit);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * this.expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithReferencingAxioms.add(curObj);
            }
            this.expandedWithReferencingAxioms.add(ax);
        }
        return axiomsAdded;
    }

    private int expandWithDefiningAxioms(OWLEntity obj, int limit) {
        HashSet<OWLAxiom> expansionAxioms = new HashSet<OWLAxiom>();
        for (OWLOntology ont : this.getOntology().getImportsClosure()) {
            boolean referenceFound = false;
            if (obj instanceof OWLClass) {
                referenceFound = expansionAxioms.addAll(ont.getAxioms((OWLClass)obj));
            } else if (obj instanceof OWLObjectProperty) {
                referenceFound = expansionAxioms.addAll(ont.getAxioms((OWLObjectProperty)obj));
            } else if (obj instanceof OWLDataProperty) {
                referenceFound = expansionAxioms.addAll(ont.getAxioms((OWLDataProperty)obj));
            } else if (obj instanceof OWLIndividual) {
                referenceFound = expansionAxioms.addAll(ont.getAxioms((OWLIndividual)((Object)obj)));
            }
            if (referenceFound) continue;
            expansionAxioms.add(this.owlOntologyManager.getOWLDataFactory().getOWLDeclarationAxiom(obj));
        }
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxExplanation.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private int expandWithReferencingAxioms(OWLEntity obj, int limit) {
        HashSet<OWLAxiom> expansionAxioms = new HashSet<OWLAxiom>();
        for (OWLOntology ont : this.getOntology().getImportsClosure()) {
            expansionAxioms.addAll(ont.getReferencingAxioms(obj));
        }
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxExplanation.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private static <N extends OWLAxiom> int addMax(Set<N> source, Set<N> dest, int limit) {
        int count = 0;
        for (OWLAxiom obj : source) {
            if (count == limit) break;
            if (obj instanceof OWLAnnotationAxiom || !dest.add(obj)) continue;
            ++count;
        }
        return count;
    }

    private void performFastPruning(OWLClassExpression unsatClass) throws OWLException {
        HashSet<OWLAxiom> axiomWindow = new HashSet<OWLAxiom>();
        Object[] axioms = this.debuggingAxioms.toArray();
        if (log.isLoggable(Level.FINE)) {
            log.info("Fast pruning: ");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("     - Window size: " + this.fastPruningWindowSize);
        }
        int windowCount = this.debuggingAxioms.size() / this.fastPruningWindowSize;
        for (int currentWindow = 0; currentWindow < windowCount; ++currentWindow) {
            axiomWindow.clear();
            int startIndex = currentWindow * this.fastPruningWindowSize;
            int endIndex = startIndex + this.fastPruningWindowSize;
            for (int axiomIndex = startIndex; axiomIndex < endIndex; ++axiomIndex) {
                OWLAxiom currentAxiom = (OWLAxiom)axioms[axiomIndex];
                axiomWindow.add(currentAxiom);
                this.debuggingAxioms.remove(currentAxiom);
            }
            if (!this.isSatisfiable(unsatClass)) continue;
            this.debuggingAxioms.addAll(axiomWindow);
        }
        axiomWindow.clear();
        int remainingAxiomsCount = this.debuggingAxioms.size() % this.fastPruningWindowSize;
        if (remainingAxiomsCount > 0) {
            for (int fragmentIndex = windowCount * this.fastPruningWindowSize; fragmentIndex < axioms.length; ++fragmentIndex) {
                OWLAxiom curAxiom = (OWLAxiom)axioms[fragmentIndex];
                axiomWindow.add(curAxiom);
                this.debuggingAxioms.remove(curAxiom);
            }
            if (this.isSatisfiable(unsatClass)) {
                this.debuggingAxioms.addAll(axiomWindow);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("    - End of fast pruning");
        }
    }

    private void performSlowPruning(OWLClassExpression unsatClass) throws OWLException {
        ArrayList<OWLAxiom> axiomsCopy = new ArrayList<OWLAxiom>(this.debuggingAxioms);
        for (OWLAxiom ax : axiomsCopy) {
            this.debuggingAxioms.remove(ax);
            if (!this.isSatisfiable(unsatClass)) continue;
            this.debuggingAxioms.add(ax);
        }
    }

    private boolean isSatisfiable(OWLClassExpression unsatClass) throws OWLException {
        this.createDebuggingOntology();
        ++this.ontologyCounter;
        OWLReasoner reasoner = this.getReasonerFactory().createNonBufferingReasoner(this.debuggingOntology);
        if (OntologyUtils.containsUnreferencedEntity(this.debuggingOntology, unsatClass)) {
            reasoner.dispose();
            return true;
        }
        ++this.satTestCount;
        boolean sat = reasoner.isSatisfiable(unsatClass);
        reasoner.dispose();
        return sat;
    }

    private void createDebuggingOntology() throws OWLException {
        if (this.debuggingOntology != null) {
            this.owlOntologyManager.removeOntology(this.debuggingOntology);
        }
        this.debuggingOntology = this.owlOntologyManager.createOntology();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLAxiom ax : this.debuggingAxioms) {
            changes.add(new AddAxiom(this.debuggingOntology, ax));
        }
        this.owlOntologyManager.applyChanges(changes);
    }

    private void resetSatisfiabilityTestCounter() {
        this.satTestCount = 0;
    }

    private void expandUntilUnsatisfiable(OWLClassExpression unsatClass) throws OWLException {
        this.resetSatisfiabilityTestCounter();
        if (!unsatClass.isAnonymous()) {
            this.expandWithDefiningAxioms((OWLClass)unsatClass, this.expansionLimit);
        } else {
            OWLClass owlThing = this.owlOntologyManager.getOWLDataFactory().getOWLThing();
            OWLSubClassOfAxiom axiom = this.owlOntologyManager.getOWLDataFactory().getOWLSubClassOfAxiom(unsatClass, owlThing);
            this.debuggingAxioms.add(axiom);
            this.expandAxioms();
            this.debuggingAxioms.remove(axiom);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initial axiom count: " + this.debuggingAxioms.size());
        }
        int totalAdded = 0;
        int expansionCount = 0;
        while (this.isSatisfiable(unsatClass)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Expanding axioms (expansion " + expansionCount + ")");
            }
            ++expansionCount;
            int numberAdded = this.expandAxioms();
            totalAdded += numberAdded;
            if (log.isLoggable(Level.FINE)) {
                log.fine("    ... expanded by " + numberAdded);
            }
            if (numberAdded != 0) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("ERROR! Cannot find SOS axioms!");
            }
            this.debuggingAxioms.clear();
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Total number of axioms added: " + totalAdded);
        }
    }

    protected void pruneUntilMinimal(OWLClassExpression unsatClass) throws OWLException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("FOUND CLASH! Pruning " + this.debuggingAxioms.size() + " axioms...");
        }
        this.resetSatisfiabilityTestCounter();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Fast pruning...");
        }
        if (this.performRepeatedFastPruning) {
            this.fastPruningWindowSize = this.debuggingAxioms.size() / 6;
            if (this.fastPruningWindowSize < 10) {
                this.fastPruningWindowSize = 10;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("    Initial fast pruning window size: " + this.fastPruningWindowSize);
            }
            int fastPruningCounter = 0;
            while (this.fastPruningWindowSize != 1) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("    Round: " + fastPruningCounter + " (axioms to prune: " + this.debuggingAxioms.size() + ")");
                }
                ++fastPruningCounter;
                this.performFastPruning(unsatClass);
                this.fastPruningWindowSize /= 3;
                if (this.fastPruningWindowSize >= 1) continue;
                this.fastPruningWindowSize = 1;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("... end of fast pruning. Axioms remaining: " + this.debuggingAxioms.size());
                log.fine("Performed " + this.satTestCount + " satisfiability tests during fast pruning");
            }
        } else {
            this.fastPruningWindowSize = 10;
            this.performFastPruning(unsatClass);
            if (log.isLoggable(Level.FINE)) {
                log.info("... end of fast pruning. Axioms remaining: " + this.debuggingAxioms.size());
                log.info("Performed " + this.satTestCount + " satisfiability tests during fast pruning");
            }
        }
        int totalSatTests = this.satTestCount;
        this.resetSatisfiabilityTestCounter();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Slow pruning...");
        }
        this.performSlowPruning(unsatClass);
        if (log.isLoggable(Level.FINE)) {
            log.fine("... end of slow pruning");
            log.fine("Performed " + this.satTestCount + " satisfiability tests during slow pruning");
        }
        totalSatTests += this.satTestCount;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Total number of satisfiability tests performed: " + totalSatTests);
        }
    }

    private void removeDeclarations() {
        OWLAxiomVisitorAdapter declarationRemover = new OWLAxiomVisitorAdapter(){

            public void visit(OWLDeclarationAxiom axiom) {
                BlackBoxExplanation.this.debuggingAxioms.remove(axiom);
            }
        };
        for (OWLAxiom axiom : this.debuggingAxioms.toArray(new OWLAxiom[this.debuggingAxioms.size()])) {
            axiom.accept(declarationRemover);
        }
    }

    public String toString() {
        return "BlackBox";
    }
}

